/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.AccountConfig;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_153;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema_154
extends SchemaVersion {
    private static final Logger log = LoggerFactory.getLogger(Schema_154.class);
    private static final String TABLE = "accounts";
    private static final ImmutableMap<String, AccountSetter> ACCOUNT_FIELDS_MAP = ImmutableMap.builder().put("full_name", (a, rs, field) -> a.setFullName(rs.getString(field))).put("preferred_email", (a, rs, field) -> a.setPreferredEmail(rs.getString(field))).put("status", (a, rs, field) -> a.setStatus(rs.getString(field))).put("inactive", (a, rs, field) -> a.setActive(rs.getString(field).equals("N"))).build();
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final Provider<PersonIdent> serverIdent;

    @Inject
    Schema_154(Provider<Schema_153> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent Provider<PersonIdent> serverIdent) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverIdent = serverIdent;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            TextProgressMonitor pm = new TextProgressMonitor();
            pm.beginTask("Collecting accounts", 0);
            Set<Account> accounts = this.scanAccounts(db, pm);
            pm.endTask();
            pm.beginTask("Migrating accounts to NoteDb", accounts.size());
            for (Account account : accounts) {
                this.updateAccountInNoteDb(repo, account);
                pm.update(1);
            }
            pm.endTask();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new OrmException("Migrating accounts to NoteDb failed", e);
        }
    }

    private Set<Account> scanAccounts(ReviewDb db, ProgressMonitor pm) throws SQLException {
        Map<String, AccountSetter> fields = this.getFields(db);
        if (fields.isEmpty()) {
            log.warn("Only account_id and registered_on fields are migrated for accounts");
        }
        ArrayList<String> queryFields = new ArrayList<String>();
        queryFields.add("account_id");
        queryFields.add("registered_on");
        queryFields.addAll(fields.keySet());
        String query = "SELECT " + String.join((CharSequence)", ", queryFields) + String.format(" FROM %s", TABLE);
        try (Statement stmt = Schema_154.newStatement(db);){
            HashSet<Account> hashSet;
            block15: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    HashSet<Account> s = new HashSet<Account>();
                    while (rs.next()) {
                        Account a = new Account(new Account.Id(rs.getInt(1)), rs.getTimestamp(2));
                        for (Map.Entry<String, AccountSetter> field : fields.entrySet()) {
                            field.getValue().set(a, rs, field.getKey());
                        }
                        s.add(a);
                        pm.update(1);
                    }
                    hashSet = s;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashSet;
        }
    }

    private Map<String, AccountSetter> getFields(ReviewDb db) throws SQLException {
        JdbcSchema schema = (JdbcSchema)((Object)db);
        Connection connection = schema.getConnection();
        Set<String> columns = schema.getDialect().listColumns(connection, TABLE);
        return ACCOUNT_FIELDS_MAP.entrySet().stream().filter(e -> columns.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void updateAccountInNoteDb(Repository allUsersRepo, Account account) throws IOException, ConfigInvalidException {
        MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, allUsersRepo);
        PersonIdent ident = this.serverIdent.get();
        md.getCommitBuilder().setAuthor(ident);
        md.getCommitBuilder().setCommitter(ident);
        AccountConfig accountConfig = new AccountConfig(null, account.getId());
        accountConfig.load(allUsersRepo);
        accountConfig.setAccount(account);
        accountConfig.commit(md);
    }

    @FunctionalInterface
    private static interface AccountSetter {
        public void set(Account var1, ResultSet var2, String var3) throws SQLException;
    }
}

