/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.Version;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.metrics.Counter0;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.ssh.SshAdvertisedAddresses;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.server.ssh.SshListenAddresses;
import com.google.gerrit.server.util.IdGenerator;
import com.google.gerrit.server.util.SocketUtil;
import com.google.gerrit.sshd.GerritGSSAuthenticator;
import com.google.gerrit.sshd.NoShell;
import com.google.gerrit.sshd.SshLog;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.sshd.common.BaseBuilder;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.forward.DefaultTcpipForwarderFactory;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.AbstractIoServiceFactory;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaServiceFactoryFactory;
import org.apache.sshd.common.io.mina.MinaSession;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.global.CancelTcpipForwardHandler;
import org.apache.sshd.server.global.KeepAliveHandler;
import org.apache.sshd.server.global.NoMoreSessionsHandler;
import org.apache.sshd.server.global.TcpipForwardHandler;
import org.apache.sshd.server.session.ServerSessionImpl;
import org.apache.sshd.server.session.SessionFactory;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SshDaemon
extends SshServer
implements SshInfo,
LifecycleListener {
    private static final Logger sshDaemonLog = LoggerFactory.getLogger(SshDaemon.class);
    private final List<SocketAddress> listen;
    private final List<String> advertised;
    private final boolean keepAlive;
    private final List<HostKey> hostKeys;
    private volatile IoAcceptor daemonAcceptor;
    private final Config cfg;

    @Inject
    SshDaemon(CommandFactory commandFactory, NoShell noShell, PublickeyAuthenticator userAuth, GerritGSSAuthenticator kerberosAuth, KeyPairProvider hostKeyProvider, final IdGenerator idGenerator, @GerritServerConfig Config cfg, final SshLog sshLog, @SshListenAddresses List<SocketAddress> listen, @SshAdvertisedAddresses List<String> advertised, MetricMaker metricMaker) {
        this.setPort(22);
        this.cfg = cfg;
        this.listen = listen;
        this.advertised = advertised;
        this.keepAlive = cfg.getBoolean("sshd", "tcpkeepalive", true);
        this.getProperties().put("server-identification", "GerritCodeReview_" + Version.getVersion() + " (" + super.getVersion() + ")");
        this.getProperties().put("max-auth-requests", String.valueOf(cfg.getInt("sshd", "maxAuthTries", 6)));
        this.getProperties().put("auth-timeout", String.valueOf(TimeUnit.MILLISECONDS.convert(ConfigUtil.getTimeUnit(cfg, "sshd", null, "loginGraceTime", 120L, TimeUnit.SECONDS), TimeUnit.SECONDS)));
        long idleTimeoutSeconds = ConfigUtil.getTimeUnit(cfg, "sshd", null, "idleTimeout", 0L, TimeUnit.SECONDS);
        this.getProperties().put("idle-timeout", String.valueOf(TimeUnit.SECONDS.toMillis(idleTimeoutSeconds)));
        this.getProperties().put("nio2-read-timeout", String.valueOf(TimeUnit.SECONDS.toMillis(idleTimeoutSeconds)));
        long rekeyTimeLimit = ConfigUtil.getTimeUnit(cfg, "sshd", null, "rekeyTimeLimit", 3600L, TimeUnit.SECONDS);
        this.getProperties().put("rekey-time-limit", String.valueOf(TimeUnit.SECONDS.toMillis(rekeyTimeLimit)));
        this.getProperties().put("rekey-bytes-limit", String.valueOf(cfg.getLong("sshd", "rekeyBytesLimit", 0x40000000L)));
        long waitTimeoutSeconds = ConfigUtil.getTimeUnit(cfg, "sshd", null, "waitTimeout", 30L, TimeUnit.SECONDS);
        this.getProperties().put("channel-output-wait-for-space-timeout", String.valueOf(TimeUnit.SECONDS.toMillis(waitTimeoutSeconds)));
        int maxConnectionsPerUser = cfg.getInt("sshd", "maxConnectionsPerUser", 64);
        if (0 < maxConnectionsPerUser) {
            this.getProperties().put("max-concurrent-sessions", String.valueOf(maxConnectionsPerUser));
        }
        String kerberosKeytab = cfg.getString("sshd", null, "kerberosKeytab");
        String kerberosPrincipal = cfg.getString("sshd", null, "kerberosPrincipal");
        boolean enableCompression = cfg.getBoolean("sshd", "enableCompression", false);
        SshSessionBackend backend = cfg.getEnum("sshd", null, "backend", SshSessionBackend.NIO2);
        System.setProperty(IoServiceFactoryFactory.class.getName(), backend == SshSessionBackend.MINA ? MinaServiceFactoryFactory.class.getName() : Nio2ServiceFactoryFactory.class.getName());
        this.initProviderBouncyCastle(cfg);
        this.initCiphers(cfg);
        this.initKeyExchanges(cfg);
        this.initMacs(cfg);
        this.initSignatures();
        this.initChannels();
        this.initForwarding();
        this.initFileSystemFactory();
        this.initSubsystems();
        this.initCompression(enableCompression);
        this.initUserAuth(userAuth, kerberosAuth, kerberosKeytab, kerberosPrincipal);
        this.setKeyPairProvider(hostKeyProvider);
        this.setCommandFactory(commandFactory);
        this.setShellFactory(noShell);
        final AtomicInteger connected = new AtomicInteger();
        metricMaker.newCallbackMetric("sshd/sessions/connected", Integer.class, new Description("Currently connected SSH sessions").setGauge().setUnit("sessions"), new Supplier<Integer>(){

            @Override
            public Integer get() {
                return connected.get();
            }
        });
        final Counter0 sessionsCreated = metricMaker.newCounter("sshd/sessions/created", new Description("Rate of new SSH sessions").setRate().setUnit("sessions"));
        final Counter0 authFailures = metricMaker.newCounter("sshd/sessions/authentication_failures", new Description("Rate of SSH authentication failures").setRate().setUnit("failures"));
        this.setSessionFactory(new SessionFactory(this){

            @Override
            protected ServerSessionImpl createSession(IoSession io) throws Exception {
                connected.incrementAndGet();
                sessionsCreated.increment();
                if (io instanceof MinaSession && ((MinaSession)io).getSession().getConfig() instanceof SocketSessionConfig) {
                    ((SocketSessionConfig)((MinaSession)io).getSession().getConfig()).setKeepAlive(SshDaemon.this.keepAlive);
                }
                ServerSessionImpl s = (ServerSessionImpl)super.createSession(io);
                int id = idGenerator.next();
                SocketAddress peer = io.getRemoteAddress();
                final SshSession sd = new SshSession(id, peer);
                s.setAttribute(SshSession.KEY, sd);
                s.addCloseFutureListener(new SshFutureListener<CloseFuture>(){

                    @Override
                    public void operationComplete(CloseFuture future) {
                        connected.decrementAndGet();
                        if (sd.isAuthenticationError()) {
                            authFailures.increment();
                            sshLog.onAuthFail(sd);
                        }
                    }
                });
                return s;
            }

            @Override
            protected ServerSessionImpl doCreateSession(IoSession ioSession) throws Exception {
                return new ServerSessionImpl(this.getServer(), ioSession);
            }
        });
        this.setGlobalRequestHandlers(Arrays.asList(new KeepAliveHandler(), new NoMoreSessionsHandler(), new TcpipForwardHandler(), new CancelTcpipForwardHandler()));
        this.hostKeys = this.computeHostKeys();
    }

    @Override
    public List<HostKey> getHostKeys() {
        return this.hostKeys;
    }

    public IoAcceptor getIoAcceptor() {
        return this.daemonAcceptor;
    }

    @Override
    public synchronized void start() {
        if (this.daemonAcceptor == null && !this.listen.isEmpty()) {
            this.checkConfig();
            if (this.getSessionFactory() == null) {
                this.setSessionFactory(this.createSessionFactory());
            }
            this.setupSessionTimeout(this.getSessionFactory());
            this.daemonAcceptor = this.createAcceptor();
            try {
                String listenAddress = this.cfg.getString("sshd", null, "listenAddress");
                boolean rewrite = !Strings.isNullOrEmpty(listenAddress) && listenAddress.endsWith(":0");
                this.daemonAcceptor.bind(this.listen);
                if (rewrite) {
                    SocketAddress bound = Iterables.getOnlyElement(this.daemonAcceptor.getBoundAddresses());
                    this.cfg.setString("sshd", null, "listenAddress", SshDaemon.format((InetSocketAddress)bound));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot bind to " + this.addressList(), e);
            }
            sshDaemonLog.info(String.format("Started Gerrit %s on %s", this.getVersion(), this.addressList()));
        }
    }

    private static String format(InetSocketAddress s) {
        return String.format("%s:%d", s.getAddress().getHostAddress(), s.getPort());
    }

    @Override
    public synchronized void stop() {
        if (this.daemonAcceptor != null) {
            try {
                this.daemonAcceptor.close(true).await();
                this.shutdownExecutors();
                sshDaemonLog.info("Stopped Gerrit SSHD");
            }
            catch (IOException e) {
                sshDaemonLog.warn("Exception caught while closing", e);
            }
            finally {
                this.daemonAcceptor = null;
            }
        }
    }

    private void shutdownExecutors() {
        IoServiceFactory serviceFactory;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if ((serviceFactory = this.getIoServiceFactory()) instanceof AbstractIoServiceFactory) {
            this.shutdownServiceFactoryExecutor((AbstractIoServiceFactory)serviceFactory);
        }
    }

    private void shutdownServiceFactoryExecutor(AbstractIoServiceFactory ioServiceFactory) {
        ioServiceFactory.close(true);
        ExecutorService serviceFactoryExecutor = ioServiceFactory.getExecutorService();
        if (serviceFactoryExecutor != null && serviceFactoryExecutor != this.executor) {
            serviceFactoryExecutor.shutdownNow();
        }
    }

    @Override
    protected void checkConfig() {
        super.checkConfig();
        if (this.myHostKeys().isEmpty()) {
            throw new IllegalStateException("No SSHD host key");
        }
    }

    private List<HostKey> computeHostKeys() {
        if (this.listen.isEmpty()) {
            return Collections.emptyList();
        }
        List<PublicKey> keys = this.myHostKeys();
        ArrayList<HostKey> r = new ArrayList<HostKey>();
        for (PublicKey pub : keys) {
            ByteArrayBuffer buf = new ByteArrayBuffer();
            buf.putRawPublicKey(pub);
            byte[] keyBin = buf.getCompactData();
            for (String addr : this.advertised) {
                try {
                    r.add(new HostKey(addr, keyBin));
                }
                catch (JSchException e) {
                    sshDaemonLog.warn(String.format("Cannot format SSHD host key [%s]: %s", pub.getAlgorithm(), e.getMessage()));
                }
            }
        }
        return Collections.unmodifiableList(r);
    }

    private List<PublicKey> myHostKeys() {
        KeyPairProvider p = this.getKeyPairProvider();
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>(6);
        SshDaemon.addPublicKey(keys, p, "ssh-ed25519");
        SshDaemon.addPublicKey(keys, p, KeyPairProvider.ECDSA_SHA2_NISTP256);
        SshDaemon.addPublicKey(keys, p, KeyPairProvider.ECDSA_SHA2_NISTP384);
        SshDaemon.addPublicKey(keys, p, KeyPairProvider.ECDSA_SHA2_NISTP521);
        SshDaemon.addPublicKey(keys, p, "ssh-rsa");
        SshDaemon.addPublicKey(keys, p, "ssh-dss");
        return keys;
    }

    private static void addPublicKey(Collection<PublicKey> out, KeyPairProvider p, String type) {
        KeyPair pair = p.loadKey(type);
        if (pair != null && pair.getPublic() != null) {
            out.add(pair.getPublic());
        }
    }

    private String addressList() {
        StringBuilder r = new StringBuilder();
        Iterator<SocketAddress> i = this.listen.iterator();
        while (i.hasNext()) {
            r.append(SocketUtil.format(i.next(), 22));
            if (!i.hasNext()) continue;
            r.append(", ");
        }
        return r.toString();
    }

    private void initKeyExchanges(Config cfg) {
        List<NamedFactory<KeyExchange>> a = ServerBuilder.setUpDefaultKeyExchanges(true);
        this.setKeyExchangeFactories(SshDaemon.filter(cfg, "kex", a.toArray(new NamedFactory[a.size()])));
    }

    private void initProviderBouncyCastle(Config cfg) {
        NamedFactory<Random> factory = cfg.getBoolean("sshd", null, "testUseInsecureRandom", false) ? new InsecureBouncyCastleRandom.Factory() : SecurityUtils.getRandomFactory();
        this.setRandomFactory(new SingletonRandomFactory(factory));
    }

    private void initCiphers(Config cfg) {
        List<NamedFactory<Cipher>> a = BaseBuilder.setUpDefaultCiphers(true);
        Iterator<NamedFactory<Cipher>> i = a.iterator();
        while (i.hasNext()) {
            NamedFactory<Cipher> f = i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                sshDaemonLog.warn("Disabling cipher " + f.getName() + ": " + e.getMessage() + "; try installing unlimited cryptography extension");
                i.remove();
            }
            catch (Exception e) {
                sshDaemonLog.warn("Disabling cipher " + f.getName() + ": " + e.getMessage());
                i.remove();
            }
        }
        a.add(null);
        this.setCipherFactories(SshDaemon.filter(cfg, "cipher", a.toArray(new NamedFactory[a.size()])));
    }

    private void initMacs(Config cfg) {
        List<NamedFactory<Mac>> m = BaseBuilder.setUpDefaultMacs(true);
        this.setMacFactories(SshDaemon.filter(cfg, "mac", m.toArray(new NamedFactory[m.size()])));
    }

    @SafeVarargs
    private static <T> List<NamedFactory<T>> filter(Config cfg, String key, NamedFactory<T> ... avail) {
        ArrayList<NamedFactory<T>> def = new ArrayList<NamedFactory<T>>();
        for (NamedFactory<T> n : avail) {
            if (n == null) break;
            def.add(n);
        }
        String[] want = cfg.getStringList("sshd", null, key);
        if (want == null || want.length == 0) {
            return def;
        }
        boolean didClear = false;
        for (String setting : want) {
            String name = setting.trim();
            boolean add = true;
            if (name.startsWith("-")) {
                add = false;
                name = name.substring(1).trim();
            } else if (name.startsWith("+")) {
                name = name.substring(1).trim();
            } else if (!didClear) {
                didClear = true;
                def.clear();
            }
            NamedFactory<T> n = SshDaemon.find(name, avail);
            if (n == null) {
                StringBuilder msg = new StringBuilder();
                msg.append("sshd.").append(key).append(" = ").append(name).append(" unsupported; only ");
                for (int i = 0; i < avail.length; ++i) {
                    if (avail[i] == null) continue;
                    if (i > 0) {
                        msg.append(", ");
                    }
                    msg.append(avail[i].getName());
                }
                msg.append(" is supported");
                sshDaemonLog.error(msg.toString());
                continue;
            }
            if (add) {
                if (def.contains(n)) continue;
                def.add(n);
                continue;
            }
            def.remove(n);
        }
        return def;
    }

    @SafeVarargs
    private static <T> NamedFactory<T> find(String name, NamedFactory<T> ... avail) {
        for (NamedFactory<T> n : avail) {
            if (n == null || !name.equals(n.getName())) continue;
            return n;
        }
        return null;
    }

    private void initSignatures() {
        this.setSignatureFactories(BaseBuilder.setUpDefaultSignatures(true));
    }

    private void initCompression(boolean enableCompression) {
        ArrayList<NamedFactory<Compression>> compressionFactories = new ArrayList<NamedFactory<Compression>>();
        compressionFactories.add(BuiltinCompressions.none);
        if (enableCompression) {
            compressionFactories.add(BuiltinCompressions.zlib);
        }
        this.setCompressionFactories(compressionFactories);
    }

    private void initChannels() {
        this.setChannelFactories(ServerBuilder.DEFAULT_CHANNEL_FACTORIES);
    }

    private void initSubsystems() {
        this.setSubsystemFactories(Collections.emptyList());
    }

    private void initUserAuth(PublickeyAuthenticator pubkey, GSSAuthenticator kerberosAuthenticator, String kerberosKeytab, String kerberosPrincipal) {
        ArrayList<NamedFactory<UserAuth>> authFactories = new ArrayList<NamedFactory<UserAuth>>();
        if (kerberosKeytab != null) {
            authFactories.add(UserAuthGSSFactory.INSTANCE);
            sshDaemonLog.info("Enabling kerberos with keytab " + kerberosKeytab);
            if (!new File(kerberosKeytab).canRead()) {
                sshDaemonLog.error("Keytab " + kerberosKeytab + " does not exist or is not readable; further errors are possible");
            }
            kerberosAuthenticator.setKeytabFile(kerberosKeytab);
            if (kerberosPrincipal == null) {
                try {
                    kerberosPrincipal = "host/" + InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    kerberosPrincipal = "host/localhost";
                }
            }
            sshDaemonLog.info("Using kerberos principal " + kerberosPrincipal);
            if (!kerberosPrincipal.startsWith("host/")) {
                sshDaemonLog.warn("Host principal does not start with host/ which most SSH clients will supply automatically");
            }
            kerberosAuthenticator.setServicePrincipalName(kerberosPrincipal);
            this.setGSSAuthenticator(kerberosAuthenticator);
        }
        authFactories.add(UserAuthPublicKeyFactory.INSTANCE);
        this.setUserAuthFactories(authFactories);
        this.setPublickeyAuthenticator(pubkey);
    }

    private void initForwarding() {
        this.setTcpipForwardingFilter(new ForwardingFilter(){

            @Override
            public boolean canForwardAgent(Session session, String requestType) {
                return false;
            }

            @Override
            public boolean canForwardX11(Session session, String requestType) {
                return false;
            }

            @Override
            public boolean canListen(SshdSocketAddress address, Session session) {
                return false;
            }

            @Override
            public boolean canConnect(ForwardingFilter.Type type, SshdSocketAddress address, Session session) {
                return false;
            }
        });
        this.setTcpipForwarderFactory(new DefaultTcpipForwarderFactory());
    }

    private void initFileSystemFactory() {
        this.setFileSystemFactory(new FileSystemFactory(){

            @Override
            public FileSystem createFileSystem(Session session) throws IOException {
                return new FileSystem(){

                    @Override
                    public void close() throws IOException {
                    }

                    @Override
                    public Iterable<FileStore> getFileStores() {
                        return null;
                    }

                    @Override
                    public Path getPath(String arg0, String ... arg1) {
                        return null;
                    }

                    @Override
                    public PathMatcher getPathMatcher(String arg0) {
                        return null;
                    }

                    @Override
                    public Iterable<Path> getRootDirectories() {
                        return null;
                    }

                    @Override
                    public String getSeparator() {
                        return null;
                    }

                    @Override
                    public UserPrincipalLookupService getUserPrincipalLookupService() {
                        return null;
                    }

                    @Override
                    public boolean isOpen() {
                        return false;
                    }

                    @Override
                    public boolean isReadOnly() {
                        return false;
                    }

                    @Override
                    public WatchService newWatchService() throws IOException {
                        return null;
                    }

                    @Override
                    public FileSystemProvider provider() {
                        return null;
                    }

                    @Override
                    public Set<String> supportedFileAttributeViews() {
                        return null;
                    }
                };
            }
        });
    }

    private static class InsecureBouncyCastleRandom
    implements Random {
        private final RandomGenerator random = new VMPCRandomGenerator();

        private InsecureBouncyCastleRandom() {
            this.random.addSeedMaterial(1234L);
        }

        @Override
        public String getName() {
            return "InsecureBouncyCastleRandom";
        }

        @Override
        public void fill(byte[] bytes, int start, int len) {
            this.random.nextBytes(bytes, start, len);
        }

        @Override
        public void fill(byte[] bytes) {
            this.random.nextBytes(bytes);
        }

        @Override
        public int random(int n) {
            if (n > 0) {
                int val;
                int bits;
                if ((n & -n) == n) {
                    return (int)((long)n * (long)this.next(31) >> 31);
                }
                while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
                }
                return val;
            }
            throw new IllegalArgumentException();
        }

        protected final int next(int numBits) {
            int bytes = (numBits + 7) / 8;
            byte[] next = new byte[bytes];
            int ret = 0;
            this.random.nextBytes(next);
            for (int i = 0; i < bytes; ++i) {
                ret = next[i] & 0xFF | ret << 8;
            }
            return ret >>> bytes * 8 - numBits;
        }

        private static class Factory
        implements NamedFactory<Random> {
            private Factory() {
            }

            @Override
            public String getName() {
                return "INSECURE_bouncycastle";
            }

            @Override
            public Random create() {
                return new InsecureBouncyCastleRandom();
            }
        }
    }

    public static enum SshSessionBackend {
        MINA,
        NIO2;

    }
}

