/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.AllowedFormats;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.project.CommitsCollection;
import com.google.gerrit.sshd.AbstractGitCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class UploadArchive
extends AbstractGitCommand {
    @Inject
    private PermissionBackend permissionBackend;
    @Inject
    private CommitsCollection commits;
    @Inject
    private IdentifiedUser user;
    @Inject
    private AllowedFormats allowedFormats;
    private Options options = new Options();

    protected void readArguments() throws IOException, BaseCommand.Failure {
        String s;
        String argCmd = "argument ";
        ArrayList<String> args = new ArrayList<String>();
        PacketLineIn packetIn = new PacketLineIn(this.in);
        while ((s = packetIn.readString()) != PacketLineIn.END) {
            String[] parts;
            if (!s.startsWith(argCmd)) {
                throw new BaseCommand.Failure(1, "fatal: 'argument' token or flush expected");
            }
            for (String p : parts = s.substring(argCmd.length()).split("=", 2)) {
                args.add(p);
            }
        }
        try {
            CmdLineParser parser = new CmdLineParser(this.options);
            parser.parseArgument(args);
            if (this.options.path == null || Arrays.asList(".").equals(this.options.path)) {
                this.options.path = Collections.emptyList();
            }
        }
        catch (CmdLineException e) {
            throw new BaseCommand.Failure(2, "fatal: unable to parse arguments, " + e);
        }
    }

    @Override
    protected void runImpl() throws IOException, PermissionBackendException, BaseCommand.Failure {
        PacketLineOut packetOut = new PacketLineOut(this.out);
        packetOut.setFlushOnEnd(true);
        packetOut.writeString("ACK");
        packetOut.end();
        try {
            this.readArguments();
            ArchiveFormat f = this.allowedFormats.getExtensions().get("." + this.options.format);
            if (f == null) {
                throw new BaseCommand.Failure(3, "fatal: upload-archive not permitted");
            }
            ObjectId treeId = this.repo.resolve(this.options.treeIsh);
            if (treeId == null) {
                throw new BaseCommand.Failure(4, "fatal: reference not found");
            }
            if (!this.canRead(treeId)) {
                throw new BaseCommand.Failure(5, "fatal: cannot perform upload-archive operation");
            }
            try (SideBandOutputStream sidebandOut = new SideBandOutputStream(1, 65520, this.out);){
                new ArchiveCommand(this.repo).setFormat(f.name()).setFormatOptions(this.getFormatOptions(f)).setTree(treeId).setPaths(this.options.path.toArray(new String[0])).setPrefix(this.options.prefix).setOutputStream(sidebandOut).call();
                sidebandOut.flush();
            }
            catch (GitAPIException e) {
                throw new BaseCommand.Failure(7, "fatal: git api exception, " + e);
            }
        }
        catch (BaseCommand.Failure f) {
            try (SideBandOutputStream sidebandError = new SideBandOutputStream(3, 65520, this.out);){
                sidebandError.write(f.getMessage().getBytes(StandardCharsets.UTF_8));
                sidebandError.flush();
            }
            throw f;
        }
        finally {
            packetOut.end();
        }
    }

    private Map<String, Object> getFormatOptions(ArchiveFormat f) {
        int value;
        if (f == ArchiveFormat.ZIP && (value = Arrays.asList(this.options.level0, this.options.level1, this.options.level2, this.options.level3, this.options.level4, this.options.level5, this.options.level6, this.options.level7, this.options.level8, this.options.level9).indexOf(true)) >= 0) {
            return ImmutableMap.of("level", value);
        }
        return Collections.emptyMap();
    }

    private boolean canRead(ObjectId revId) throws IOException, PermissionBackendException {
        try {
            this.permissionBackend.user(this.user).project(this.projectName).check(ProjectPermission.READ);
            return true;
        }
        catch (AuthException e) {
            try (RevWalk rw = new RevWalk(this.repo);){
                RevCommit commit = rw.parseCommit(revId);
                boolean bl = this.commits.canRead(this.state, this.repo, commit);
                return bl;
            }
        }
    }

    static class Options {
        @Option(name="-f", aliases={"--format"}, usage="Format of the resulting archive: tar or zip... If this option is not given, and the output file is specified, the format is inferred from the filename if possible (e.g. writing to \"foo.zip\" makes the output to be in the zip format). Otherwise the output format is tar.")
        private String format = "tar";
        @Option(name="--prefix", usage="Prepend <prefix>/ to each filename in the archive.")
        private String prefix;
        @Option(name="-0", usage="Store the files instead of deflating them.")
        private boolean level0;
        @Option(name="-1")
        private boolean level1;
        @Option(name="-2")
        private boolean level2;
        @Option(name="-3")
        private boolean level3;
        @Option(name="-4")
        private boolean level4;
        @Option(name="-5")
        private boolean level5;
        @Option(name="-6")
        private boolean level6;
        @Option(name="-7")
        private boolean level7;
        @Option(name="-8")
        private boolean level8;
        @Option(name="-9", usage="Highest and slowest compression level. You can specify any number from 1 to 9 to adjust compression speed and ratio.")
        private boolean level9;
        @Argument(index=0, required=true, usage="The tree or commit to produce an archive for.")
        private String treeIsh = "master";
        @Argument(index=1, multiValued=true, usage="Without an optional path parameter, all files and subdirectories of the current working directory are included in the archive. If one or more paths are specified, only these are included.")
        private List<String> path;

        Options() {
        }
    }
}

