/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.util.http;

import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    private static final String ATTRIBUTE_ERROR_TRACE = RequestUtil.class.getName() + "/ErrorTraceThrowable";

    public static void setErrorTraceAttribute(HttpServletRequest req, Throwable t) {
        req.setAttribute(ATTRIBUTE_ERROR_TRACE, t);
    }

    public static Throwable getErrorTraceAttribute(HttpServletRequest req) {
        return (Throwable)req.getAttribute(ATTRIBUTE_ERROR_TRACE);
    }

    public static String getEncodedPathInfo(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        int servletPathLength = servletPath.length();
        String requestUri = req.getRequestURI();
        String pathInfo = requestUri.substring(req.getContextPath().length()).replaceAll("[/]{2,}", "/");
        if (pathInfo.startsWith(servletPath)) {
            if ((pathInfo = pathInfo.substring(servletPathLength)).isEmpty() && servletPathLength > 0) {
                pathInfo = null;
            }
        } else {
            pathInfo = null;
        }
        return pathInfo;
    }

    private RequestUtil() {
    }
}

