/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtjsonrpc.common.RemoteJsonService;
import com.google.gwtjsonrpc.server.ActiveCall;
import com.google.gwtjsonrpc.server.CallDeserializer;
import com.google.gwtjsonrpc.server.MapDeserializer;
import com.google.gwtjsonrpc.server.MethodHandle;
import com.google.gwtjsonrpc.server.NoSuchRemoteMethodException;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.gwtjsonrpc.server.SignedToken;
import com.google.gwtjsonrpc.server.SqlDateDeserializer;
import com.google.gwtjsonrpc.server.SqlTimestampDeserializer;
import com.google.gwtjsonrpc.server.XsrfException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;

public abstract class JsonServlet<CallType extends ActiveCall>
extends HttpServlet {
    public static final Pattern SAFE_CALLBACK = Pattern.compile("^([A-Za-z0-9_$.]|\\[|\\])+$");
    private static final ThreadLocal<ActiveCall> perThreadCall = new ThreadLocal();
    static final Object[] NO_PARAMS = new Object[0];
    private static final String ENC = "UTF-8";
    private Map<String, MethodHandle> myMethods;
    private SignedToken xsrf;

    public static <CallType extends ActiveCall> CallType getCurrentCall() {
        return (CallType)perThreadCall.get();
    }

    public static GsonBuilder defaultGsonBuilder() {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter((Type)((Object)Set.class), new InstanceCreator<Set<Object>>(){

            @Override
            public Set<Object> createInstance(Type arg0) {
                return new HashSet<Object>();
            }
        });
        gb.registerTypeAdapter((Type)((Object)Map.class), new MapDeserializer());
        gb.registerTypeAdapter((Type)((Object)Date.class), new SqlDateDeserializer());
        gb.registerTypeAdapter((Type)((Object)Timestamp.class), new SqlTimestampDeserializer());
        return gb;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        RemoteJsonService impl;
        super.init(config);
        try {
            impl = (RemoteJsonService)this.createServiceHandle();
        }
        catch (Exception e) {
            throw new ServletException("Service handle not available", e);
        }
        this.myMethods = JsonServlet.methods(impl);
        if (this.myMethods.isEmpty()) {
            throw new ServletException("No service methods declared");
        }
        try {
            this.xsrf = this.createXsrfSignedToken();
        }
        catch (XsrfException e) {
            throw new ServletException("Cannot initialize XSRF", e);
        }
    }

    protected Object createServiceHandle() throws Exception {
        return this;
    }

    protected SignedToken createXsrfSignedToken() throws XsrfException {
        return new SignedToken(14400);
    }

    protected GsonBuilder createGsonBuilder() {
        return JsonServlet.defaultGsonBuilder();
    }

    protected boolean xsrfValidate(CallType call) throws XsrfException {
        return ((ActiveCall)call).xsrfValidate();
    }

    protected MethodHandle lookupMethod(String methodName) {
        return this.myMethods.get(methodName);
    }

    protected CallType createActiveCall(HttpServletRequest req, HttpServletResponse resp) {
        return (CallType)new ActiveCall(req, resp);
    }

    protected int maxRequestSize() {
        return 0x100000;
    }

    protected void preInvoke(CallType call) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            CallType call = this.createActiveCall(req, resp);
            ((ActiveCall)call).xsrf = this.xsrf;
            ((ActiveCall)call).noCache();
            if (!this.acceptJSON(call)) {
                JsonServlet.textError(call, 400, "Must Accept application/json");
                return;
            }
            perThreadCall.set((ActiveCall)call);
            this.doService(call);
            if (((ActiveCall)call).internalFailure != null) {
                String msg = "Error in " + ((ActiveCall)call).method.getName();
                this.getServletContext().log(msg, ((ActiveCall)call).internalFailure);
                ((ActiveCall)call).onFailure(new Exception("Internal Server Error"));
            }
            String out = this.formatResult((ActiveCall)call);
            RPCServletUtils.writeResponse(this.getServletContext(), ((ActiveCall)call).httpResponse, out, ((ActiveCall)call).callback == null && out.length() > 256 && RPCServletUtils.acceptsGzipEncoding(((ActiveCall)call).httpRequest));
        }
        finally {
            perThreadCall.set(null);
        }
    }

    private boolean acceptJSON(CallType call) {
        String[] parts;
        String accepts = ((ActiveCall)call).httpRequest.getHeader("Accept");
        if (accepts == null) {
            return false;
        }
        if ("application/json".equals(accepts)) {
            return true;
        }
        if (accepts.startsWith("application/json,")) {
            return true;
        }
        for (String p : parts = accepts.split("[ ,;][ ,;]*")) {
            if (!"application/json".equals(p)) continue;
            return true;
        }
        return false;
    }

    private void doService(CallType call) throws IOException {
        block13: {
            try {
                try {
                    if ("GET".equals(((ActiveCall)call).httpRequest.getMethod())) {
                        this.parseGetRequest(call);
                        if (!((ActiveCall)call).method.allowCrossSiteRequest()) {
                            ((ActiveCall)call).onFailure(new Exception("Invalid xsrfKey in request"));
                            return;
                        }
                        break block13;
                    }
                    if ("POST".equals(((ActiveCall)call).httpRequest.getMethod())) {
                        this.parsePostRequest(call);
                        break block13;
                    }
                    ((ActiveCall)call).httpResponse.setStatus(400);
                    ((ActiveCall)call).onFailure(new Exception("Unsupported HTTP method"));
                    return;
                }
                catch (JsonParseException err) {
                    if (err.getCause() instanceof NoSuchRemoteMethodException) {
                        throw (NoSuchRemoteMethodException)err.getCause();
                    }
                    ((ActiveCall)call).httpResponse.setStatus(400);
                    ((ActiveCall)call).onFailure(new Exception("Error parsing request", err));
                    return;
                }
            }
            catch (NoSuchRemoteMethodException err) {
                ((ActiveCall)call).httpResponse.setStatus(404);
                ((ActiveCall)call).onFailure(new Exception("No such service method"));
                return;
            }
        }
        if (((ActiveCall)call).callback != null && !SAFE_CALLBACK.matcher(((ActiveCall)call).callback).matches()) {
            ((ActiveCall)call).httpResponse.setStatus(400);
            ((ActiveCall)call).onFailure(new Exception("Unsafe name in 'callback' property"));
            return;
        }
        try {
            ((ActiveCall)call).xsrfValid = this.xsrfValidate(call);
        }
        catch (XsrfException e) {
            this.getServletContext().log("Unexpected XSRF validation error", e);
            ((ActiveCall)call).xsrfValid = false;
        }
        if (!((ActiveCall)call).method.allowCrossSiteRequest() && !((ActiveCall)call).requireXsrfValid()) {
            return;
        }
        this.preInvoke(call);
        if (!((ActiveCall)call).isComplete()) {
            ((ActiveCall)call).method.invoke(((ActiveCall)call).params, (ActiveCall)call);
        }
    }

    private void parseGetRequest(CallType call) {
        HttpServletRequest req = ((ActiveCall)call).httpRequest;
        if ("2.0".equals(req.getParameter("jsonrpc"))) {
            JsonObject d = new JsonObject();
            d.addProperty("jsonrpc", "2.0");
            d.addProperty("method", req.getParameter("method"));
            d.addProperty("id", req.getParameter("id"));
            try {
                byte[] params = req.getParameter("params").getBytes("ISO-8859-1");
                String p = new String(Base64.decodeBase64(params), ENC);
                d.add("params", new JsonParser().parse(p));
            }
            catch (UnsupportedEncodingException e) {
                throw new JsonParseException("Cannot parse params", e);
            }
            try {
                GsonBuilder gb = this.createGsonBuilder();
                gb.registerTypeAdapter((Type)((Object)ActiveCall.class), new CallDeserializer<CallType>(call, this));
                gb.create().fromJson((JsonElement)d, ActiveCall.class);
            }
            catch (JsonParseException err) {
                ((ActiveCall)call).method = null;
                ((ActiveCall)call).params = null;
                throw err;
            }
        }
        Gson gs = this.createGsonBuilder().create();
        ((ActiveCall)call).method = this.lookupMethod(req.getParameter("method"));
        if (((ActiveCall)call).method == null) {
            throw new NoSuchRemoteMethodException();
        }
        Type[] paramTypes = ((ActiveCall)call).method.getParamTypes();
        Object[] r = new Object[paramTypes.length];
        for (int i = 0; i < r.length; ++i) {
            String v = req.getParameter("param" + i);
            r[i] = v == null ? null : (paramTypes[i] == String.class ? v : (paramTypes[i] instanceof Class && ((Class)paramTypes[i]).isPrimitive() ? gs.fromJson(v, paramTypes[i]) : gs.fromJson(gs.toJson(v), paramTypes[i])));
        }
        ((ActiveCall)call).params = r;
        ((ActiveCall)call).callback = req.getParameter("callback");
    }

    private static boolean isBodyJson(ActiveCall call) {
        String type = call.httpRequest.getContentType();
        if (type == null) {
            return false;
        }
        int semi = type.indexOf(59);
        if (semi >= 0) {
            type = type.substring(0, semi).trim();
        }
        return "application/json".equals(type);
    }

    private static boolean isBodyUTF8(ActiveCall call) {
        String enc = call.httpRequest.getCharacterEncoding();
        if (enc == null) {
            enc = "";
        }
        return enc.toLowerCase().contains(ENC.toLowerCase());
    }

    private String readBody(ActiveCall call) throws IOException {
        if (!JsonServlet.isBodyJson(call)) {
            throw new JsonParseException("Invalid Request Content-Type");
        }
        if (!JsonServlet.isBodyUTF8(call)) {
            throw new JsonParseException("Invalid Request Character-Encoding");
        }
        int len = call.httpRequest.getContentLength();
        if (len < 0) {
            throw new JsonParseException("Invalid Request Content-Length");
        }
        if (len == 0) {
            throw new JsonParseException("Invalid Request POST Body Required");
        }
        if (len > this.maxRequestSize()) {
            throw new JsonParseException("Invalid Request POST Body Too Large");
        }
        ServletInputStream in = call.httpRequest.getInputStream();
        if (in == null) {
            throw new JsonParseException("Invalid Request POST Body Required");
        }
        try {
            int n;
            byte[] body = new byte[len];
            for (int off = 0; off < len; off += n) {
                n = in.read(body, off, len - off);
                if (n > 0) continue;
                throw new JsonParseException("Invalid Request Incomplete Body");
            }
            CharsetDecoder d = Charset.forName(ENC).newDecoder();
            d.onMalformedInput(CodingErrorAction.REPORT);
            d.onUnmappableCharacter(CodingErrorAction.REPORT);
            try {
                String string = d.decode(ByteBuffer.wrap(body)).toString();
                return string;
            }
            catch (CharacterCodingException e) {
                throw new JsonParseException("Invalid Request Not UTF-8", e);
            }
        }
        finally {
            in.close();
        }
    }

    private void parsePostRequest(CallType call) throws UnsupportedEncodingException, IOException {
        try {
            GsonBuilder gb = this.createGsonBuilder();
            gb.registerTypeAdapter((Type)((Object)ActiveCall.class), new CallDeserializer<CallType>(call, this));
            gb.create().fromJson(this.readBody((ActiveCall)call), ActiveCall.class);
        }
        catch (JsonParseException err) {
            ((ActiveCall)call).method = null;
            ((ActiveCall)call).params = null;
            throw err;
        }
    }

    private String formatResult(final ActiveCall call) throws UnsupportedEncodingException, IOException {
        GsonBuilder gb = this.createGsonBuilder();
        gb.registerTypeAdapter(call.getClass(), new JsonSerializer<ActiveCall>(){

            @Override
            public JsonElement serialize(ActiveCall src, Type typeOfSrc, JsonSerializationContext context) {
                if (call.callback != null) {
                    if (src.externalFailure != null) {
                        return new JsonNull();
                    }
                    return context.serialize(src.result);
                }
                JsonObject r = new JsonObject();
                r.add(src.versionName, src.versionValue);
                if (src.id != null) {
                    r.add("id", src.id);
                }
                if (src.xsrfKeyOut != null) {
                    r.addProperty("xsrfKey", src.xsrfKeyOut);
                }
                if (src.externalFailure != null) {
                    JsonObject error = new JsonObject();
                    if ("jsonrpc".equals(src.versionName)) {
                        int code = JsonServlet.this.to2_0ErrorCode(src);
                        error.addProperty("code", code);
                        error.addProperty("message", src.externalFailure.getMessage());
                    } else {
                        error.addProperty("name", "JSONRPCError");
                        error.addProperty("code", 999);
                        error.addProperty("message", src.externalFailure.getMessage());
                    }
                    r.add("error", error);
                } else {
                    r.add("result", context.serialize(src.result));
                }
                return r;
            }
        });
        StringWriter o = new StringWriter();
        if (call.callback != null) {
            o.write(call.callback);
            o.write("(");
        }
        gb.create().toJson((Object)call, (Appendable)o);
        if (call.callback != null) {
            o.write(");");
        }
        o.close();
        return o.toString();
    }

    private int to2_0ErrorCode(ActiveCall src) {
        Throwable e = src.externalFailure;
        Throwable i = src.internalFailure;
        if (e instanceof NoSuchRemoteMethodException || i instanceof NoSuchRemoteMethodException) {
            return -32601;
        }
        if (e instanceof JsonParseException || i instanceof JsonParseException) {
            return -32700;
        }
        return -32603;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void textError(ActiveCall call, int status, String message) throws IOException {
        HttpServletResponse r = call.httpResponse;
        r.setStatus(status);
        r.setContentType("text/plain; charset=UTF-8");
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)r.getOutputStream(), ENC);){
            w.write(message);
        }
    }

    private static Map<String, MethodHandle> methods(RemoteJsonService impl) {
        Class<RemoteJsonService> d = JsonServlet.findInterface(impl.getClass());
        if (d == null) {
            return Collections.emptyMap();
        }
        HashMap<String, MethodHandle> r = new HashMap<String, MethodHandle>();
        for (Method m : d.getMethods()) {
            Class<?>[] params;
            if (!Modifier.isPublic(m.getModifiers()) || m.getReturnType() != Void.TYPE || (params = m.getParameterTypes()).length < 1 || !params[params.length - 1].isAssignableFrom(AsyncCallback.class)) continue;
            MethodHandle h = new MethodHandle(impl, m);
            r.put(h.getName(), h);
        }
        return Collections.unmodifiableMap(r);
    }

    private static Class<? extends RemoteJsonService> findInterface(Class<?> clazz) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            if (c.isInterface() && RemoteJsonService.class.isAssignableFrom(c)) {
                return c;
            }
            for (Class<?> i : c.getInterfaces()) {
                Class<RemoteJsonService> r = JsonServlet.findInterface(i);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }
}

