/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class DialectDerby
extends SqlDialect {
    public DialectDerby() {
        this.typeNames.put(-5, "BIGINT");
        this.typeNames.put(-1, "LONG VARCHAR");
        this.typeNames.put(-3, "VARCHAR (32672) FOR BIT DATA");
    }

    @Override
    public boolean isStatementDelimiterSupported() {
        return false;
    }

    @Override
    public boolean handles(String url, Connection c) {
        return url.startsWith("jdbc:derby:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSequences(Connection db) throws SQLException {
        try (Statement s = db.createStatement();){
            HashSet<String> hashSet;
            ResultSet rs = s.executeQuery("select sequencename from sys.syssequences");
            try {
                HashSet<String> sequences = new HashSet<String>();
                while (rs.next()) {
                    sequences.add(rs.getString(1).toLowerCase());
                }
                hashSet = sequences;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    @Override
    public void renameColumn(StatementExecutor e, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuffer sb = new StringBuffer();
        sb.append("RENAME COLUMN ");
        sb.append(tableName);
        sb.append('.');
        sb.append(fromColumn);
        sb.append(" TO ");
        sb.append(col.getColumnName());
        e.execute(sb.toString());
    }

    @Override
    public void renameTable(StatementExecutor e, String from, String to) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("RENAME TABLE ");
        r.append(from);
        r.append(" TO ");
        r.append(to);
        r.append(" ");
        e.execute(r.toString());
    }

    @Override
    protected String getNextSequenceValueSql(String seqname) {
        return "VALUES (NEXT VALUE FOR " + seqname + ")";
    }

    @Override
    public String getDropSequenceSql(String name) {
        return "DROP SEQUENCE " + name + " RESTRICT";
    }

    @Override
    public String getLimitSql(String limit) {
        return "FETCH FIRST " + limit + " ROWS ONLY";
    }

    @Override
    public OrmException convertError(String op, String entity, SQLException err) {
        int state = DialectDerby.getSQLStateInt(err);
        switch (state) {
            case 23505: {
                return new OrmDuplicateKeyException(entity, err);
            }
        }
        return super.convertError(op, entity, err);
    }
}

