/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class DialectH2
extends SqlDialect {
    @Override
    public boolean handles(String url, Connection c) {
        return url.startsWith("jdbc:h2:");
    }

    @Override
    public OrmException convertError(String op, String entity, SQLException err) {
        switch (DialectH2.getSQLStateInt(err)) {
            case 23001: 
            case 23505: {
                return new OrmDuplicateKeyException(entity, err);
            }
        }
        return super.convertError(op, entity, err);
    }

    @Override
    protected String getNextSequenceValueSql(String seqname) {
        return "SELECT NEXT VALUE FOR " + seqname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSequences(Connection db) throws SQLException {
        try (Statement s = db.createStatement();){
            HashSet<String> hashSet;
            ResultSet rs = s.executeQuery("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA = 'PUBLIC'");
            try {
                HashSet<String> sequences = new HashSet<String>();
                while (rs.next()) {
                    sequences.add(rs.getString(1).toLowerCase());
                }
                hashSet = sequences;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    @Override
    public void addColumn(StatementExecutor stmt, String tableName, ColumnModel col) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" ADD ");
        r.append(col.getColumnName());
        r.append(" ");
        r.append(this.getSqlTypeInfo(col).getSqlType(col, this));
        stmt.execute(r.toString());
        String check = this.getSqlTypeInfo(col).getCheckConstraint(col, this);
        if (check != null) {
            r.setLength(0);
            r.append("ALTER TABLE ");
            r.append(tableName);
            r.append(" ADD CONSTRAINT ");
            r.append(tableName + "_" + col.getColumnName() + "_check");
            r.append(' ');
            r.append(check);
            stmt.execute(r.toString());
        }
    }

    @Override
    public void renameColumn(StatementExecutor stmt, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" ALTER COLUMN ");
        r.append(fromColumn);
        r.append(" RENAME TO ");
        r.append(col.getColumnName());
        stmt.execute(r.toString());
    }
}

