/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Conditional;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import javax.annotation.CheckReturnValue;

public final class ConditionalExpressionBuilder {
    private final ConditionalBuilder underlying;

    ConditionalExpressionBuilder(CodeChunk.WithValue predicate, CodeChunk.WithValue consequent) {
        this.underlying = new ConditionalBuilder(predicate, consequent);
    }

    public ConditionalExpressionBuilder elseif_(CodeChunk.WithValue predicate, CodeChunk.WithValue consequent) {
        this.underlying.elseif_(predicate, consequent);
        return this;
    }

    public ConditionalExpressionBuilder else_(CodeChunk.WithValue trailingElse) {
        this.underlying.else_(trailingElse);
        return this;
    }

    @CheckReturnValue
    public CodeChunk.WithValue build(CodeChunk.Generator codeGenerator) {
        CodeChunk chunk = this.underlying.build();
        return chunk instanceof Conditional ? ((Conditional)chunk).asConditionalExpression(codeGenerator) : (CodeChunk.WithValue)chunk;
    }
}

