/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.ConditionalExpressionBuilder;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenJsExprsVisitor
extends AbstractSoyNodeVisitor<List<CodeChunk.WithValue>> {
    private static final SoyErrorKind ARITY_MISMATCH = SoyErrorKind.of("Print directive ''{0}'' called with {1} arguments, expected {2}.");
    private static final SoyErrorKind UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE = SoyErrorKind.of("Unknown SoyJsSrcPrintDirective ''{0}''.");
    private final Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private final TranslationContext translationContext;
    private final ErrorReporter errorReporter;
    protected List<CodeChunk.WithValue> chunks;
    private final TemplateAliases templateAliases;

    @AssistedInject
    public GenJsExprsVisitor(Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitorFactory genJsExprsVisitorFactory, @Assisted TranslationContext translationContext, @Assisted ErrorReporter errorReporter, @Assisted TemplateAliases templateAliases) {
        this.soyJsSrcDirectivesMap = soyJsSrcDirectivesMap;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.translationContext = translationContext;
        this.errorReporter = errorReporter;
        this.templateAliases = templateAliases;
    }

    @Override
    public List<CodeChunk.WithValue> exec(SoyNode node) {
        Preconditions.checkArgument((Boolean)this.isComputableAsJsExprsVisitor.exec(node));
        this.chunks = new ArrayList<CodeChunk.WithValue>();
        this.visit(node);
        return this.chunks;
    }

    public List<CodeChunk.WithValue> execOnChildren(SoyNode.ParentSoyNode<?> node) {
        Preconditions.checkArgument(this.isComputableAsJsExprsVisitor.execOnChildren(node));
        this.chunks = new ArrayList<CodeChunk.WithValue>();
        this.visitChildren(node);
        return this.chunks;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        this.chunks.add(CodeChunk.stringLiteral(node.getRawText()));
    }

    @Override
    protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        CodeChunk.WithValue expr = this.jsExprTranslator.translateToCodeChunk(node.getExpr(), this.translationContext, this.errorReporter);
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyJsSrcPrintDirective directive = this.soyJsSrcDirectivesMap.get(directiveNode.getName());
            if (directive == null) {
                this.errorReporter.report(node.getSourceLocation(), UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE, directiveNode.getName());
                return;
            }
            List<ExprRootNode> argNodes = directiveNode.getArgs();
            if (!directive.getValidArgsSizes().contains(argNodes.size())) {
                this.errorReporter.report(node.getSourceLocation(), ARITY_MISMATCH, directiveNode.getName(), argNodes.size(), directive.getValidArgsSizes());
                return;
            }
            ArrayList<CodeChunk.WithValue> argChunks = new ArrayList<CodeChunk.WithValue>(argNodes.size());
            for (ExprRootNode argNode : argNodes) {
                argChunks.add(this.jsExprTranslator.translateToCodeChunk(argNode, this.translationContext, this.errorReporter));
            }
            expr = SoyJsPluginUtils.applyDirective(this.translationContext.codeGenerator(), expr, directive, argChunks);
        }
        this.chunks.add(expr);
    }

    @Override
    protected void visitXidNode(XidNode node) {
        this.chunks.add(JsRuntime.XID.call(CodeChunk.stringLiteral(node.getText())));
    }

    @Override
    protected void visitCssNode(CssNode node) {
        ArrayList<CodeChunk.WithValue> args = new ArrayList<CodeChunk.WithValue>();
        ExprRootNode componentName = node.getComponentNameExpr();
        if (componentName != null) {
            args.add(this.jsExprTranslator.translateToCodeChunk(componentName, this.translationContext, this.errorReporter));
        }
        args.add(CodeChunk.stringLiteral(node.getSelectorText()));
        this.chunks.add(JsRuntime.GOOG_GET_CSS_NAME.call(args));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        GenJsExprsVisitor genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.translationContext, this.templateAliases, this.errorReporter);
        CodeChunk.Generator generator = this.translationContext.codeGenerator();
        ArrayList<CodeChunk.WithValue> ifs = new ArrayList<CodeChunk.WithValue>();
        ArrayList<CodeChunk.WithValue> thens = new ArrayList<CodeChunk.WithValue>();
        CodeChunk.WithValue trailingElse = null;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode ifCond = (IfCondNode)child;
                ifs.add(this.jsExprTranslator.translateToCodeChunk(ifCond.getExpr(), this.translationContext, this.errorReporter));
                thens.add(CodeChunkUtils.concatChunks(genJsExprsVisitor.exec(ifCond)));
                continue;
            }
            if (child instanceof IfElseNode) {
                trailingElse = CodeChunkUtils.concatChunks(genJsExprsVisitor.exec(child));
                continue;
            }
            throw new AssertionError();
        }
        Preconditions.checkState(ifs.size() == thens.size());
        ConditionalExpressionBuilder builder = CodeChunk.ifExpression((CodeChunk.WithValue)ifs.get(0), (CodeChunk.WithValue)thens.get(0));
        for (int i = 1; i < ifs.size(); ++i) {
            builder.elseif_((CodeChunk.WithValue)ifs.get(i), (CodeChunk.WithValue)thens.get(i));
        }
        CodeChunk.WithValue ifChunk = trailingElse != null ? builder.else_(trailingElse).build(generator) : builder.else_(CodeChunk.WithValue.LITERAL_EMPTY_STRING).build(generator);
        this.chunks.add(ifChunk);
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        CodeChunk.WithValue call = this.genCallCodeUtils.gen(node, this.templateAliases, this.translationContext, this.errorReporter);
        this.chunks.add(call);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitChildren(node);
    }

    public static interface GenJsExprsVisitorFactory {
        public GenJsExprsVisitor create(TranslationContext var1, TemplateAliases var2, ErrorReporter var3);
    }
}

