/*
 * Decompiled with CFR 0.152.
 */
package gerrit;

import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.rules.StoredValues;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.permissions.LabelPermission;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.googlecode.prolog_cafe.exceptions.IllegalTypeException;
import com.googlecode.prolog_cafe.exceptions.JavaException;
import com.googlecode.prolog_cafe.exceptions.PInstantiationException;
import com.googlecode.prolog_cafe.exceptions.PrologException;
import com.googlecode.prolog_cafe.exceptions.SystemException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;

class PRED__check_user_label_3
extends Predicate.P3 {
    PRED__check_user_label_3(Term a1, Term a2, Term a3, Operation n) {
        this.arg1 = a1;
        this.arg2 = a2;
        this.arg3 = a3;
        this.cont = n;
    }

    @Override
    public Operation exec(Prolog engine) throws PrologException {
        engine.setB0();
        Term a1 = this.arg1.dereference();
        Term a2 = this.arg2.dereference();
        Term a3 = this.arg3.dereference();
        if (a1 instanceof VariableTerm) {
            throw new PInstantiationException(this, 1);
        }
        if (!(a1 instanceof SymbolTerm)) {
            throw new IllegalTypeException(this, 1, "atom", a1);
        }
        String label = a1.name();
        if (a2 instanceof VariableTerm) {
            throw new PInstantiationException(this, 2);
        }
        if (!(a2 instanceof JavaObjectTerm) || !a2.convertible(CurrentUser.class)) {
            throw new IllegalTypeException(this, 2, "CurrentUser)", a2);
        }
        CurrentUser user = (CurrentUser)((JavaObjectTerm)a2).object();
        if (a3 instanceof VariableTerm) {
            throw new PInstantiationException(this, 3);
        }
        if (!(a3 instanceof IntegerTerm)) {
            throw new IllegalTypeException(this, 3, "integer", a3);
        }
        short val = (short)((IntegerTerm)a3).intValue();
        try {
            ChangeData cd = StoredValues.CHANGE_DATA.get(engine);
            LabelType type = cd.getLabelTypes().byLabel(label);
            if (type == null) {
                return engine.fail();
            }
            StoredValues.PERMISSION_BACKEND.get(engine).user(user).change(cd).check(new LabelPermission.WithValue(type, val));
            return this.cont;
        }
        catch (OrmException err) {
            throw new JavaException(this, 1, err);
        }
        catch (AuthException err) {
            return engine.fail();
        }
        catch (PermissionBackendException err) {
            SystemException se = new SystemException(err.getMessage());
            se.initCause(err);
            throw se;
        }
    }
}

