/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.NetworkChannel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;

public abstract class Nio2Service
extends AbstractInnerCloseable
implements IoService,
FactoryManagerHolder {
    public static final Map<String, Pair<SocketOption<?>, Object>> CONFIGURABLE_OPTIONS = Collections.unmodifiableMap(new LinkedHashMap<String, Pair<SocketOption<?>, Object>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("socket-keepalive", new Pair<SocketOption<Boolean>, Object>(StandardSocketOptions.SO_KEEPALIVE, null));
            this.put("socket-linger", new Pair<SocketOption<Integer>, Object>(StandardSocketOptions.SO_LINGER, null));
            this.put("socket-rcvbuf", new Pair<SocketOption<Integer>, Object>(StandardSocketOptions.SO_RCVBUF, null));
            this.put("socket-reuseaddr", new Pair<SocketOption<Boolean>, Boolean>(StandardSocketOptions.SO_REUSEADDR, true));
            this.put("socket-sndbuf", new Pair<SocketOption<Integer>, Object>(StandardSocketOptions.SO_SNDBUF, null));
            this.put("tcp-nodelay", new Pair<SocketOption<Boolean>, Object>(StandardSocketOptions.TCP_NODELAY, null));
        }
    });
    protected final Map<Long, IoSession> sessions;
    protected final AtomicBoolean disposing = new AtomicBoolean();
    private final FactoryManager manager;
    private final IoHandler handler;
    private final AsynchronousChannelGroup group;

    protected Nio2Service(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating {}", (Object)this.getClass().getSimpleName());
        }
        this.manager = Objects.requireNonNull(manager, "No factory manager provided");
        this.handler = Objects.requireNonNull(handler, "No I/O handler provided");
        this.group = Objects.requireNonNull(group, "No async. channel group provided");
        this.sessions = new ConcurrentHashMap<Long, IoSession>();
    }

    protected AsynchronousChannelGroup getChannelGroup() {
        return this.group;
    }

    @Override
    public FactoryManager getFactoryManager() {
        return this.manager;
    }

    public IoHandler getIoHandler() {
        return this.handler;
    }

    public void dispose() {
        block4: {
            try {
                long maxWait = Closeable.getMaxCloseWaitTime(this.getFactoryManager());
                boolean successful = this.close(true).await(maxWait);
                if (!successful) {
                    throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(e.getClass().getSimpleName() + " while stopping service: " + e.getMessage());
                }
                if (!this.log.isTraceEnabled()) break block4;
                this.log.trace("Stop exception details", e);
            }
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().parallel(this.sessions.values()).build();
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }

    public void sessionClosed(Nio2Session session) {
        this.sessions.remove(session.getId());
    }

    protected <S extends NetworkChannel> S setSocketOptions(S socket) throws IOException {
        Set<SocketOption<?>> supported = socket.supportedOptions();
        if (GenericUtils.isEmpty(supported)) {
            return socket;
        }
        for (Map.Entry<String, Pair<SocketOption<?>, Object>> ce : CONFIGURABLE_OPTIONS.entrySet()) {
            String property = ce.getKey();
            Pair<SocketOption<?>, Object> defConfig = ce.getValue();
            SocketOption<?> option = defConfig.getKey();
            this.setOption(socket, property, option, defConfig.getValue());
        }
        return socket;
    }

    protected <T> boolean setOption(NetworkChannel socket, String property, SocketOption<T> option, T defaultValue) throws IOException {
        FactoryManager manager = this.getFactoryManager();
        String valStr = manager.getString(property);
        T val = defaultValue;
        if (!GenericUtils.isEmpty(valStr)) {
            Class<T> type = option.type();
            if (type == Integer.class) {
                val = type.cast(Integer.valueOf(valStr));
            } else if (type == Boolean.class) {
                val = type.cast(Boolean.valueOf(valStr));
            } else {
                throw new IllegalStateException("Unsupported socket option type (" + type + ") " + property + "=" + valStr);
            }
        }
        if (val == null) {
            return false;
        }
        Set<SocketOption<?>> supported = socket.supportedOptions();
        if (GenericUtils.isEmpty(supported) || !supported.contains(option)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unsupported socket option ({}) to set using {}={}", option, property, val);
            }
            return false;
        }
        try {
            socket.setOption(option, val);
            if (this.log.isDebugEnabled()) {
                this.log.debug("setOption({})[{}] from property={}", option, val, property);
            }
            return true;
        }
        catch (IOException | RuntimeException e) {
            this.log.warn("Unable (" + e.getClass().getSimpleName() + ")" + " to set socket option " + option + " using property " + property + "=" + val + ": " + e.getMessage());
            return false;
        }
    }
}

