/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyRandomArt;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.WelcomeBannerPhase;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public class ServerUserAuthService
extends AbstractCloseable
implements Service,
ServerSessionHolder {
    private final ServerSession serverSession;
    private final AtomicBoolean welcomeSent = new AtomicBoolean(false);
    private final WelcomeBannerPhase welcomePhase;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private List<List<String>> authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;
    private int maxAuthRequests;
    private int nbAuthRequests;

    public ServerUserAuthService(Session s) throws IOException {
        this.serverSession = ValidateUtils.checkInstanceOf((Object)s, ServerSession.class, "Server side service used on client side: %s", (Object)s);
        if (s.isAuthenticated()) {
            throw new SshException("Session already authenticated");
        }
        Object phase = PropertyResolverUtils.getObject(s, "welcome-banner-phase");
        this.welcomePhase = (phase = PropertyResolverUtils.toEnum(WelcomeBannerPhase.class, phase, true, WelcomeBannerPhase.VALUES)) == null ? ServerAuthenticationManager.DEFAULT_BANNER_PHASE : (WelcomeBannerPhase)((Object)phase);
        this.maxAuthRequests = s.getIntProperty("max-auth-requests", 20);
        List<NamedFactory<UserAuth>> factories = ValidateUtils.checkNotNullAndNotEmpty(this.serverSession.getUserAuthFactories(), "No user auth factories for %s", s);
        this.userAuthFactories = new ArrayList<NamedFactory<UserAuth>>(factories);
        this.authMethods = new ArrayList<List<String>>();
        String mths = s.getString("auth-methods");
        if (GenericUtils.isEmpty(mths)) {
            for (NamedFactory<UserAuth> namedFactory : factories) {
                this.authMethods.add(new ArrayList<String>(Collections.singletonList(namedFactory.getName())));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ServerUserAuthService({}) using configured methods={}", (Object)s, (Object)mths);
            }
            for (String mthl : mths.split("\\s")) {
                this.authMethods.add(new ArrayList<String>(Arrays.asList(GenericUtils.split(mthl, ','))));
            }
        }
        for (List list : this.authMethods) {
            for (String m : list) {
                NamedFactory<UserAuth> factory = NamedResource.findByName(m, String.CASE_INSENSITIVE_ORDER, this.userAuthFactories);
                if (factory != null) continue;
                throw new SshException("Configured method is not supported: " + m);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ServerUserAuthService({}) authorized authentication methods: {}", (Object)s, (Object)NamedResource.getNames(this.userAuthFactories));
        }
    }

    public WelcomeBannerPhase getWelcomePhase() {
        return this.welcomePhase;
    }

    @Override
    public void start() {
    }

    @Override
    public ServerSession getSession() {
        return this.getServerSession();
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(int cmd, Buffer buffer) throws Exception {
        Boolean authed;
        block32: {
            authed = Boolean.FALSE;
            ServerSession session = this.getServerSession();
            if (cmd == 50) {
                Factory factory;
                if (WelcomeBannerPhase.FIRST_REQUEST.equals((Object)this.getWelcomePhase())) {
                    this.sendWelcomeBanner(session);
                }
                if (this.currentAuth != null) {
                    try {
                        this.currentAuth.destroy();
                    }
                    finally {
                        this.currentAuth = null;
                    }
                }
                String username = buffer.getString();
                String service = buffer.getString();
                String method = buffer.getString();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Received SSH_MSG_USERAUTH_REQUEST user={}, service={}, method={}", session, username, service, method);
                }
                if (this.authUserName == null || this.authService == null) {
                    this.authUserName = username;
                    this.authService = service;
                } else if (this.authUserName.equals(username) && this.authService.equals(service)) {
                    ++this.nbAuthRequests;
                    if (this.nbAuthRequests > this.maxAuthRequests) {
                        session.disconnect(2, "Too many authentication failures: " + this.nbAuthRequests);
                        return;
                    }
                } else {
                    session.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + username + ", " + service + ")");
                    return;
                }
                this.authMethod = method;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Authenticating user '{}' with service '{}' and method '{}' (attempt {} / {})", session, username, service, method, this.nbAuthRequests, this.maxAuthRequests);
                }
                if ((factory = (Factory)NamedResource.findByName(method, String.CASE_INSENSITIVE_ORDER, this.userAuthFactories)) != null) {
                    this.currentAuth = (UserAuth)ValidateUtils.checkNotNull(factory.create(), "No authenticator created for method=%s", (Object)method);
                    try {
                        authed = this.currentAuth.auth(session, username, service, buffer);
                    }
                    catch (Exception e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("process({}) Failed ({}) to authenticate using factory method={}: {}", session, e.getClass().getSimpleName(), method, e.getMessage());
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("process(" + session + ") factory authentication=" + method + " failure details", e);
                        }
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) no authentication factory for method={}", (Object)session, (Object)method);
                }
            } else {
                if (WelcomeBannerPhase.FIRST_AUTHCMD.equals((Object)this.getWelcomePhase())) {
                    this.sendWelcomeBanner(session);
                }
                if (this.currentAuth == null) {
                    throw new IllegalStateException("No current authentication mechanism for cmd=" + SshConstants.getCommandMessageName(cmd));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Received authentication message={} for mechanism={}", session, SshConstants.getCommandMessageName(cmd), this.currentAuth.getName());
                }
                buffer.rpos(buffer.rpos() - 1);
                try {
                    authed = this.currentAuth.next(buffer);
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("process({}) Failed ({}) to authenticate using current method={}: {}", session, e.getClass().getSimpleName(), this.currentAuth.getName(), e.getMessage());
                    }
                    if (!this.log.isTraceEnabled()) break block32;
                    this.log.trace("process(" + session + ") current authentication=" + this.currentAuth.getName() + " failure details", e);
                }
            }
        }
        if (authed == null) {
            this.handleAuthenticationInProgress(cmd, buffer);
        } else if (authed.booleanValue()) {
            this.handleAuthenticationSuccess(cmd, buffer);
        } else {
            this.handleAuthenticationFailure(cmd, buffer);
        }
    }

    protected void handleAuthenticationInProgress(int cmd, Buffer buffer) throws Exception {
        String username;
        String string = username = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationInProgress({}@{}) {}", username, this.getServerSession(), SshConstants.getCommandMessageName(cmd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationSuccess(int cmd, Buffer buffer) throws Exception {
        String username = Objects.requireNonNull(this.currentAuth, "No current auth").getUsername();
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationSuccess({}@{}) {}", username, session, SshConstants.getCommandMessageName(cmd));
        }
        boolean success = false;
        for (List<String> l2 : this.authMethods) {
            if (GenericUtils.size(l2) <= 0 || !l2.get(0).equals(this.authMethod)) continue;
            l2.remove(0);
            success |= l2.isEmpty();
        }
        if (success) {
            int currentSessionCount;
            Integer maxSessionCount = session.getInteger("max-concurrent-sessions");
            if (maxSessionCount != null && (currentSessionCount = session.getActiveSessionCountForUser(username)) >= maxSessionCount) {
                session.disconnect(12, "Too many concurrent connections (" + currentSessionCount + ") - max. allowed: " + maxSessionCount);
                return;
            }
            if (WelcomeBannerPhase.POST_SUCCESS.equals((Object)this.getWelcomePhase())) {
                this.sendWelcomeBanner(session);
            }
            buffer = session.createBuffer((byte)52, 8);
            session.writePacket(buffer);
            session.setUsername(username);
            session.setAuthenticated();
            session.startService(this.authService);
            session.resetIdleTimeout();
            this.log.info("Session {}@{} authenticated", (Object)username, (Object)session.getIoSession().getRemoteAddress());
        } else {
            String remaining = this.authMethods.stream().filter(GenericUtils::isNotEmpty).map(l -> (String)l.get(0)).collect(Collectors.joining(","));
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleAuthenticationSuccess({}@{}) remaining methods={}", username, session, remaining);
            }
            buffer = session.createBuffer((byte)51, remaining.length() + 8);
            buffer.putString(remaining);
            buffer.putBoolean(true);
            session.writePacket(buffer);
        }
        try {
            this.currentAuth.destroy();
        }
        finally {
            this.currentAuth = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationFailure(int cmd, Buffer buffer) throws Exception {
        String username;
        ServerSession session = this.getServerSession();
        if (WelcomeBannerPhase.FIRST_FAILURE.equals((Object)this.getWelcomePhase())) {
            this.sendWelcomeBanner(session);
        }
        String string = username = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationFailure({}@{}) {}", username, session, SshConstants.getCommandMessageName(cmd));
        }
        StringBuilder sb = new StringBuilder((this.authMethods.size() + 1) * 8);
        for (List<String> l : this.authMethods) {
            String m;
            if (GenericUtils.size(l) <= 0 || "none".equals(m = l.get(0))) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(m);
        }
        String remaining = sb.toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationFailure({}@{}) remaining methods: {}", username, session, remaining);
        }
        buffer = session.createBuffer((byte)51, remaining.length() + 8);
        buffer.putString(remaining);
        buffer.putBoolean(false);
        session.writePacket(buffer);
        if (this.currentAuth != null) {
            try {
                this.currentAuth.destroy();
            }
            finally {
                this.currentAuth = null;
            }
        }
    }

    public IoWriteFuture sendWelcomeBanner(ServerSession session) throws IOException {
        if (this.welcomeSent.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendWelcomeBanner({}) already sent", (Object)session);
            }
            return null;
        }
        String welcomeBanner = this.resolveWelcomeBanner(session);
        if (GenericUtils.isEmpty(welcomeBanner)) {
            return null;
        }
        String lang = PropertyResolverUtils.getStringProperty(session, "welcome-banner-language", "en");
        Buffer buffer = session.createBuffer((byte)53, welcomeBanner.length() + GenericUtils.length(lang) + 64);
        buffer.putString(welcomeBanner);
        buffer.putString(lang);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWelcomeBanner({}) send banner (length={}, lang={})", session, welcomeBanner.length(), lang);
        }
        return session.writePacket(buffer);
    }

    protected String resolveWelcomeBanner(ServerSession session) throws IOException {
        Object bannerValue = session.getObject("welcome-banner");
        if (bannerValue == null) {
            return null;
        }
        if (bannerValue instanceof CharSequence) {
            String message = bannerValue.toString();
            if (GenericUtils.isEmpty(message)) {
                return null;
            }
            if ("#auto-welcome-banner".equalsIgnoreCase(message)) {
                try {
                    return KeyRandomArt.combine(' ', session.getKeyPairProvider());
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(e);
                }
            }
            if (!message.contains("://")) {
                return message;
            }
            try {
                bannerValue = new URI(message);
            }
            catch (URISyntaxException e) {
                this.log.error("resolveWelcomeBanner({}) bad path URI {}: {}", session, message, e.getMessage());
                throw new MalformedURLException(e.getClass().getSimpleName() + " - bad URI (" + message + "): " + e.getMessage());
            }
            if (message.startsWith("file:/")) {
                bannerValue = Paths.get((URI)bannerValue);
            }
        }
        if (bannerValue instanceof File) {
            bannerValue = ((File)bannerValue).toPath();
        }
        if (bannerValue instanceof Path) {
            Path path = (Path)bannerValue;
            if (!Files.exists(path, new LinkOption[0]) || Files.size(path) <= 0L) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resolveWelcomeBanner({}) file is empty/does not exist", (Object)session, (Object)path);
                }
                return null;
            }
            bannerValue = path.toUri();
        }
        if (bannerValue instanceof URI) {
            bannerValue = ((URI)bannerValue).toURL();
        }
        if (bannerValue instanceof URL) {
            Charset cs = PropertyResolverUtils.getCharset(session, "welcome-banner-charset", Charset.defaultCharset());
            return this.loadWelcomeBanner(session, (URL)bannerValue, cs);
        }
        return bannerValue.toString();
    }

    protected String loadWelcomeBanner(ServerSession session, URL url, Charset cs) throws IOException {
        try (InputStream stream = url.openStream();){
            byte[] bytes = IoUtils.toByteArray(stream);
            String string = NumberUtils.isEmpty(bytes) ? "" : new String(bytes, cs);
            return string;
        }
    }

    public ServerFactoryManager getFactoryManager() {
        return this.serverSession.getFactoryManager();
    }
}

