/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.ReplaceEdit;

public class EditDeserializer
implements JsonDeserializer<Edit>,
JsonSerializer<Edit> {
    @Override
    public Edit deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        if (!json.isJsonArray()) {
            throw new JsonParseException("Expected array for Edit type");
        }
        JsonArray o = (JsonArray)json;
        int cnt = o.size();
        if (cnt < 4 || cnt % 4 != 0) {
            throw new JsonParseException("Expected array of 4 for Edit type");
        }
        if (4 == cnt) {
            return new Edit(EditDeserializer.get(o, 0), EditDeserializer.get(o, 1), EditDeserializer.get(o, 2), EditDeserializer.get(o, 3));
        }
        ArrayList<Edit> l = new ArrayList<Edit>(cnt / 4 - 1);
        int i = 4;
        while (i < cnt) {
            int as = EditDeserializer.get(o, i++);
            int ae = EditDeserializer.get(o, i++);
            int bs = EditDeserializer.get(o, i++);
            int be = EditDeserializer.get(o, i++);
            l.add(new Edit(as, ae, bs, be));
        }
        return new ReplaceEdit(EditDeserializer.get(o, 0), EditDeserializer.get(o, 1), EditDeserializer.get(o, 2), EditDeserializer.get(o, 3), l);
    }

    private static int get(JsonArray a, int idx) throws JsonParseException {
        JsonElement v = a.get(idx);
        if (!v.isJsonPrimitive()) {
            throw new JsonParseException("Expected array of 4 for Edit type");
        }
        JsonPrimitive p = (JsonPrimitive)v;
        if (!p.isNumber()) {
            throw new JsonParseException("Expected array of 4 for Edit type");
        }
        return p.getAsInt();
    }

    @Override
    public JsonElement serialize(Edit src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        JsonArray a = new JsonArray();
        this.add(a, src);
        if (src instanceof ReplaceEdit) {
            for (Edit e : ((ReplaceEdit)src).getInternalEdits()) {
                this.add(a, e);
            }
        }
        return a;
    }

    private void add(JsonArray a, Edit src) {
        a.add(new JsonPrimitive(src.getBeginA()));
        a.add(new JsonPrimitive(src.getEndA()));
        a.add(new JsonPrimitive(src.getBeginB()));
        a.add(new JsonPrimitive(src.getEndB()));
    }
}

