/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Deque;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.common.Factory;
import org.parboiled.common.Reference;

public class Var<T>
extends Reference<T> {
    private final Factory<T> factory;
    private final Deque<T> stack = Lists.newLinkedList();
    private int level;
    private String name;

    public Var() {
        this((Object)null);
    }

    public Var(final @Nullable T value) {
        super(value);
        this.factory = new Factory<T>(){

            @Override
            @Nullable
            public T create() {
                return value;
            }
        };
    }

    public Var(@Nonnull Factory<T> factory) {
        this.factory = Preconditions.checkNotNull(factory);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean enterFrame() {
        if (this.level++ > 0) {
            this.stack.add(this.get());
        }
        return this.set(this.factory.create());
    }

    public boolean exitFrame() {
        if (--this.level > 0) {
            this.set(this.stack.removeLast());
        }
        return true;
    }

    public String toString() {
        return Optional.fromNullable(this.name).or(super.toString());
    }
}

