/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.Rule;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class FlagMarkingGenerator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        return method.hasSuppressNodeAnnotation() || method.hasSuppressSubnodesAnnotation() || method.hasSkipNodeAnnotation() || method.hasMemoMismatchesAnnotation();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkState(!method.isSuperMethod());
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        instructions.insertBefore(ret, new InsnNode(89));
        LabelNode isNullLabel = new LabelNode();
        instructions.insertBefore(ret, new JumpInsnNode(198, isNullLabel));
        if (method.hasSuppressNodeAnnotation()) {
            FlagMarkingGenerator.generateMarkerCall(instructions, ret, "suppressNode");
        }
        if (method.hasSuppressSubnodesAnnotation()) {
            FlagMarkingGenerator.generateMarkerCall(instructions, ret, "suppressSubnodes");
        }
        if (method.hasSkipNodeAnnotation()) {
            FlagMarkingGenerator.generateMarkerCall(instructions, ret, "skipNode");
        }
        if (method.hasMemoMismatchesAnnotation()) {
            FlagMarkingGenerator.generateMarkerCall(instructions, ret, "memoMismatches");
        }
        instructions.insertBefore(ret, isNullLabel);
    }

    private static void generateMarkerCall(InsnList instructions, AbstractInsnNode ret, String call) {
        MethodInsnNode insn = new MethodInsnNode(185, CodegenUtils.p(Rule.class), call, CodegenUtils.sig(Rule.class, new Class[0]), true);
        instructions.insertBefore(ret, insn);
    }
}

