/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.misc;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import javax.annotation.Nonnull;
import org.parboiled.common.Sink;

public final class SinkWriter
extends Writer
implements Sink<String> {
    private final Sink<String> sink;

    public SinkWriter(@Nonnull Sink<String> sink) {
        this.sink = Preconditions.checkNotNull(sink);
    }

    @Override
    public void receive(String value) {
        this.sink.receive(value);
    }

    @Override
    public void write(@Nonnull char[] cbuf, int off, int len) throws IOException {
        Preconditions.checkNotNull(cbuf);
        String toWrite = CharBuffer.wrap(cbuf, off, len).toString();
        this.sink.receive(toWrite);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

