/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.transform.asm;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;

public final class LoadingOpcode {
    private static final Map<Integer, Integer> LOADING_OPCODES;

    private LoadingOpcode() {
    }

    public static int forType(@Nonnull Type type) {
        Preconditions.checkNotNull(type);
        return Optional.fromNullable(LOADING_OPCODES.get(type.getSort())).get();
    }

    static {
        ImmutableMap.Builder<Integer, Integer> builder = ImmutableMap.builder();
        builder.put(1, 21);
        builder.put(3, 21);
        builder.put(2, 21);
        builder.put(4, 21);
        builder.put(5, 21);
        builder.put(8, 24);
        builder.put(6, 23);
        builder.put(7, 22);
        builder.put(10, 25);
        builder.put(9, 25);
        LOADING_OPCODES = builder.build();
    }
}

