/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.audit;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.audit.AutoValue_AuditEvent_UUID;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.server.CurrentUser;

public class AuditEvent {
    public static final String UNKNOWN_SESSION_ID = "000000000000000000000000000";
    protected static final ImmutableListMultimap<String, ?> EMPTY_PARAMS = ImmutableListMultimap.of();
    public final String sessionId;
    public final CurrentUser who;
    public final long when;
    public final String what;
    public final ListMultimap<String, ?> params;
    public final Object result;
    public final long timeAtStart;
    public final long elapsed;
    public final UUID uuid;

    public AuditEvent(String sessionId, CurrentUser who, String what, long when, ListMultimap<String, ?> params, Object result) {
        Preconditions.checkNotNull(what, "what is a mandatory not null param !");
        this.sessionId = MoreObjects.firstNonNull(sessionId, UNKNOWN_SESSION_ID);
        this.who = who;
        this.what = what;
        this.timeAtStart = this.when = when;
        this.params = MoreObjects.firstNonNull(params, EMPTY_PARAMS);
        this.uuid = UUID.create();
        this.result = result;
        this.elapsed = TimeUtil.nowMs() - this.timeAtStart;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditEvent other = (AuditEvent)obj;
        return this.uuid.equals(other.uuid);
    }

    public String toString() {
        return String.format("AuditEvent UUID:%s, SID:%s, TS:%d, who:%s, what:%s", this.uuid.uuid(), this.sessionId, this.when, this.who, this.what);
    }

    @AutoValue
    public static abstract class UUID {
        private static UUID create() {
            return new AutoValue_AuditEvent_UUID(String.format("audit:%s", java.util.UUID.randomUUID().toString()));
        }

        public abstract String uuid();
    }
}

