/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommentDetail {
    protected List<Comment> a;
    protected List<Comment> b;
    private transient PatchSet.Id idA;
    private transient PatchSet.Id idB;
    private transient Map<Integer, List<Comment>> forA;
    private transient Map<Integer, List<Comment>> forB;

    public CommentDetail(PatchSet.Id idA, PatchSet.Id idB) {
        this.a = new ArrayList<Comment>();
        this.b = new ArrayList<Comment>();
        this.idA = idA;
        this.idB = idB;
    }

    protected CommentDetail() {
    }

    public void include(Change.Id changeId, Comment p) {
        PatchSet.Id psId = new PatchSet.Id(changeId, p.key.patchSetId);
        if (p.side == 0) {
            if (this.idA == null && this.idB.equals(psId)) {
                this.a.add(p);
            }
        } else if (p.side == 1) {
            if (this.idA != null && this.idA.equals(psId)) {
                this.a.add(p);
            } else if (this.idB.equals(psId)) {
                this.b.add(p);
            }
        }
    }

    public List<Comment> getCommentsA() {
        return this.a;
    }

    public List<Comment> getCommentsB() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.a.isEmpty() && this.b.isEmpty();
    }

    public List<Comment> getForA(int lineNbr) {
        if (this.forA == null) {
            this.forA = this.index(this.a);
        }
        return CommentDetail.get(this.forA, lineNbr);
    }

    public List<Comment> getForB(int lineNbr) {
        if (this.forB == null) {
            this.forB = this.index(this.b);
        }
        return CommentDetail.get(this.forB, lineNbr);
    }

    private static List<Comment> get(Map<Integer, List<Comment>> m, int i) {
        List<Comment> r = m.get(i);
        return r != null ? CommentDetail.orderComments(r) : Collections.emptyList();
    }

    private static List<Comment> orderComments(List<Comment> comments) {
        HashMap<String, List<Comment>> parentMap = new HashMap<String, List<Comment>>();
        ArrayList<Comment> rootComments = new ArrayList<Comment>();
        for (Comment c : comments) {
            String parentUuid = c.parentUuid;
            ArrayList<Comment> l = (ArrayList<Comment>)parentMap.get(parentUuid);
            if (l == null) {
                l = new ArrayList<Comment>();
                parentMap.put(parentUuid, l);
            }
            l.add(c);
            if (parentUuid != null) continue;
            rootComments.add(c);
        }
        ArrayList<Comment> result = new ArrayList<Comment>();
        CommentDetail.addChildren(parentMap, rootComments, result);
        return result;
    }

    private static void addChildren(Map<String, List<Comment>> parentMap, List<Comment> children, List<Comment> outResult) {
        if (children != null) {
            for (Comment c : children) {
                outResult.add(c);
                CommentDetail.addChildren(parentMap, parentMap.get(c.key.uuid), outResult);
            }
        }
    }

    private Map<Integer, List<Comment>> index(List<Comment> in) {
        HashMap<Integer, List<Comment>> r = new HashMap<Integer, List<Comment>>();
        for (Comment p : in) {
            List<Comment> l = r.get(p.lineNbr);
            if (l == null) {
                l = new ArrayList<Comment>();
                r.put(p.lineNbr, l);
            }
            l.add(p);
        }
        return r;
    }
}

