/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.accounts;

import com.google.gerrit.extensions.api.accounts.AccountApi;
import com.google.gerrit.extensions.api.accounts.AccountInput;
import com.google.gerrit.extensions.client.ListAccountsOption;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public interface Accounts {
    public AccountApi id(String var1) throws RestApiException;

    public AccountApi id(int var1) throws RestApiException;

    public AccountApi self() throws RestApiException;

    public AccountApi create(String var1) throws RestApiException;

    public AccountApi create(AccountInput var1) throws RestApiException;

    public SuggestAccountsRequest suggestAccounts() throws RestApiException;

    public SuggestAccountsRequest suggestAccounts(String var1) throws RestApiException;

    public QueryRequest query() throws RestApiException;

    public QueryRequest query(String var1) throws RestApiException;

    public static class NotImplemented
    implements Accounts {
        @Override
        public AccountApi id(String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AccountApi id(int id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AccountApi self() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AccountApi create(String username) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AccountApi create(AccountInput input) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SuggestAccountsRequest suggestAccounts() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SuggestAccountsRequest suggestAccounts(String query) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query(String query) throws RestApiException {
            throw new NotImplementedException();
        }
    }

    public static abstract class QueryRequest {
        private String query;
        private int limit;
        private int start;
        private EnumSet<ListAccountsOption> options = EnumSet.noneOf(ListAccountsOption.class);

        public abstract List<AccountInfo> get() throws RestApiException;

        public QueryRequest withQuery(String query) {
            this.query = query;
            return this;
        }

        public QueryRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public QueryRequest withStart(int start) {
            this.start = start;
            return this;
        }

        public QueryRequest withOption(ListAccountsOption options) {
            this.options.add(options);
            return this;
        }

        public QueryRequest withOptions(ListAccountsOption ... options) {
            this.options.addAll(Arrays.asList(options));
            return this;
        }

        public QueryRequest withOptions(EnumSet<ListAccountsOption> options) {
            this.options = options;
            return this;
        }

        public String getQuery() {
            return this.query;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getStart() {
            return this.start;
        }

        public EnumSet<ListAccountsOption> getOptions() {
            return this.options;
        }
    }

    public static abstract class SuggestAccountsRequest {
        private String query;
        private int limit;

        public abstract List<AccountInfo> get() throws RestApiException;

        public SuggestAccountsRequest withQuery(String query) {
            this.query = query;
            return this;
        }

        public SuggestAccountsRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public String getQuery() {
            return this.query;
        }

        public int getLimit() {
            return this.limit;
        }
    }
}

