/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.Strings;
import com.google.gerrit.httpd.ProxyProperties;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jgit.lib.Config;

@Singleton
class ProxyPropertiesProvider
implements Provider<ProxyProperties> {
    private URL proxyUrl;
    private String proxyUser;
    private String proxyPassword;

    @Inject
    ProxyPropertiesProvider(@GerritServerConfig Config config) throws MalformedURLException {
        String proxyUrlStr = config.getString("http", null, "proxy");
        if (!Strings.isNullOrEmpty(proxyUrlStr)) {
            this.proxyUrl = new URL(proxyUrlStr);
            this.proxyUser = config.getString("http", null, "proxyUsername");
            this.proxyPassword = config.getString("http", null, "proxyPassword");
            String userInfo = this.proxyUrl.getUserInfo();
            if (userInfo != null) {
                int c = userInfo.indexOf(58);
                if (0 < c) {
                    this.proxyUser = userInfo.substring(0, c);
                    this.proxyPassword = userInfo.substring(c + 1);
                } else {
                    this.proxyUser = userInfo;
                }
            }
        }
    }

    @Override
    public ProxyProperties get() {
        return new ProxyProperties(){

            @Override
            public URL getProxyUrl() {
                return ProxyPropertiesProvider.this.proxyUrl;
            }

            @Override
            public String getUsername() {
                return ProxyPropertiesProvider.this.proxyUser;
            }

            @Override
            public String getPassword() {
                return ProxyPropertiesProvider.this.proxyPassword;
            }
        };
    }
}

