/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.cache.Cache;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.httpd.raw.ResourceServlet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;

class DirectoryGwtUiServlet
extends ResourceServlet {
    private static final long serialVersionUID = 1L;
    private static final FileTime NOW = FileTime.fromMillis(TimeUtil.nowMs());
    private final Path ui;

    DirectoryGwtUiServlet(Cache<Path, ResourceServlet.Resource> cache, Path unpackedWar, boolean dev) throws IOException {
        super(cache, false);
        this.ui = unpackedWar.resolve("gerrit_ui");
        if (!Files.exists(this.ui, new LinkOption[0])) {
            Files.createDirectory(this.ui, new FileAttribute[0]);
        }
        if (dev) {
            this.ui.toFile().deleteOnExit();
        }
    }

    @Override
    protected Path getResourcePath(String pathInfo) {
        return this.ui.resolve(pathInfo);
    }

    @Override
    protected FileTime getLastModifiedTime(Path p) {
        return NOW;
    }
}

