/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.gerrit.index.AutoValue_QueryOptions;
import com.google.gerrit.index.IndexConfig;
import java.util.Set;

@AutoValue
public abstract class QueryOptions {
    public static QueryOptions create(IndexConfig config, int start, int limit, Set<String> fields) {
        Preconditions.checkArgument(start >= 0, "start must be nonnegative: %s", start);
        Preconditions.checkArgument(limit > 0, "limit must be positive: %s", limit);
        return new AutoValue_QueryOptions(config, start, limit, ImmutableSet.copyOf(fields));
    }

    public QueryOptions convertForBackend() {
        int backendLimit = this.config().maxLimit();
        int limit = Ints.saturatedCast((long)this.limit() + (long)this.start());
        limit = Math.min(limit, backendLimit);
        return QueryOptions.create(this.config(), 0, limit, this.fields());
    }

    public abstract IndexConfig config();

    public abstract int start();

    public abstract int limit();

    public abstract ImmutableSet<String> fields();

    public QueryOptions withLimit(int newLimit) {
        return QueryOptions.create(this.config(), this.start(), newLimit, this.fields());
    }

    public QueryOptions withStart(int newStart) {
        return QueryOptions.create(this.config(), newStart, this.limit(), this.fields());
    }
}

