/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.proc;

import com.google.gerrit.metrics.proc.OperatingSystemMXBeanInterface;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

class OperatingSystemMXBeanReflectionBased
implements OperatingSystemMXBeanInterface {
    private final OperatingSystemMXBean sys;
    private final Method getProcessCpuTime;
    private final Method getOpenFileDescriptorCount;

    OperatingSystemMXBeanReflectionBased(OperatingSystemMXBean sys) throws ReflectiveOperationException {
        this.sys = sys;
        this.getProcessCpuTime = sys.getClass().getMethod("getProcessCpuTime", new Class[0]);
        this.getProcessCpuTime.setAccessible(true);
        this.getOpenFileDescriptorCount = sys.getClass().getMethod("getOpenFileDescriptorCount", new Class[0]);
        this.getOpenFileDescriptorCount.setAccessible(true);
    }

    @Override
    public long getProcessCpuTime() {
        try {
            return (Long)this.getProcessCpuTime.invoke((Object)this.sys, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return -1L;
        }
    }

    @Override
    public long getOpenFileDescriptorCount() {
        try {
            return (Long)this.getOpenFileDescriptorCount.invoke((Object)this.sys, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return -1L;
        }
    }
}

