/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.init.api;

import com.google.gerrit.pgm.init.api.AllProjectsNameOnInitProvider;
import com.google.gerrit.pgm.init.api.InitFlags;
import com.google.gerrit.pgm.init.api.VersionedMetaDataOnInit;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GroupList;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RepositoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllProjectsConfig
extends VersionedMetaDataOnInit {
    private static final Logger log = LoggerFactory.getLogger(AllProjectsConfig.class);
    private Config cfg;
    private GroupList groupList;

    @Inject
    AllProjectsConfig(AllProjectsNameOnInitProvider allProjects, SitePaths site, InitFlags flags) {
        super(flags, site, allProjects.get(), "refs/meta/config");
    }

    public Config getConfig() {
        return this.cfg;
    }

    public GroupList getGroups() {
        return this.groupList;
    }

    @Override
    public AllProjectsConfig load() throws IOException, ConfigInvalidException {
        super.load();
        return this;
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        this.groupList = this.readGroupList();
        this.cfg = this.readConfig("project.config");
    }

    private GroupList readGroupList() throws IOException {
        return GroupList.parse(new Project.NameKey(this.project), this.readUTF8("groups"), error -> log.error("Error parsing file {}: {}", (Object)"groups", (Object)error.getMessage()));
    }

    public void save(String pluginName, String message) throws IOException, ConfigInvalidException {
        this.save(new PersonIdent(pluginName, pluginName + "@gerrit"), "Update from plugin " + pluginName + ": " + message);
    }

    @Override
    protected void save(PersonIdent ident, String msg) throws IOException, ConfigInvalidException {
        super.save(ident, msg);
        RepositoryCache.clear();
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        this.saveConfig("project.config", this.cfg);
        this.saveGroupList();
        return true;
    }

    private void saveGroupList() throws IOException {
        this.saveUTF8("groups", this.groupList.asText());
    }
}

