/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.StringKey;

public final class Branch {
    protected NameKey name;
    protected RevId revision;
    protected boolean canDelete;

    protected Branch() {
    }

    public Branch(NameKey newName) {
        this.name = newName;
    }

    public NameKey getNameKey() {
        return this.name;
    }

    public String getName() {
        return this.name.get();
    }

    public String getShortName() {
        return this.name.getShortName();
    }

    public RevId getRevision() {
        return this.revision;
    }

    public void setRevision(RevId id) {
        this.revision = id;
    }

    public boolean getCanDelete() {
        return this.canDelete;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public static class NameKey
    extends StringKey<Project.NameKey> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Project.NameKey projectName;
        @Column(id=2)
        protected String branchName;

        protected NameKey() {
            this.projectName = new Project.NameKey();
        }

        public NameKey(Project.NameKey proj, String branchName) {
            this.projectName = proj;
            this.set(branchName);
        }

        public NameKey(String proj, String branchName) {
            this(new Project.NameKey(proj), branchName);
        }

        @Override
        public String get() {
            return this.branchName;
        }

        @Override
        protected void set(String newValue) {
            this.branchName = RefNames.fullName(newValue);
        }

        @Override
        public Project.NameKey getParentKey() {
            return this.projectName;
        }

        public String getShortName() {
            return RefNames.shortName(this.get());
        }
    }
}

