/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.change.ChangeTriplet;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class ChangeFinder {
    private static final String CACHE_NAME = "changeid_project";
    private final IndexConfig indexConfig;
    private final Cache<Change.Id, String> changeIdProjectCache;
    private final Provider<InternalChangeQuery> queryProvider;
    private final Provider<ReviewDb> reviewDb;
    private final ChangeNotes.Factory changeNotesFactory;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(ChangeFinder.CACHE_NAME, Change.Id.class, String.class).maximumWeight(1024L);
            }
        };
    }

    @Inject
    ChangeFinder(IndexConfig indexConfig, @Named(value="changeid_project") Cache<Change.Id, String> changeIdProjectCache, Provider<InternalChangeQuery> queryProvider, Provider<ReviewDb> reviewDb, ChangeNotes.Factory changeNotesFactory) {
        this.indexConfig = indexConfig;
        this.changeIdProjectCache = changeIdProjectCache;
        this.queryProvider = queryProvider;
        this.reviewDb = reviewDb;
        this.changeNotesFactory = changeNotesFactory;
    }

    public ChangeNotes findOne(String id) throws OrmException {
        List<ChangeNotes> ctls = this.find(id);
        if (ctls.size() != 1) {
            return null;
        }
        return ctls.get(0);
    }

    public List<ChangeNotes> find(String id) throws OrmException {
        Optional<ChangeTriplet> triplet;
        Integer n;
        if (id.isEmpty()) {
            return Collections.emptyList();
        }
        int z = id.lastIndexOf(126);
        int y = id.lastIndexOf(126, z - 1);
        if (y < 0 && z > 0 && (n = Ints.tryParse(id.substring(z + 1))) != null) {
            return this.fromProjectNumber(id.substring(0, z), n);
        }
        if (y < 0 && z < 0 && (n = Ints.tryParse(id)) != null) {
            return this.find(new Change.Id(n));
        }
        InternalChangeQuery query = this.queryProvider.get().noFields();
        if (id.matches("^([0-9a-fA-F]{7,40})$")) {
            return this.asChangeNotes(query.byCommit(id));
        }
        if (y > 0 && z > 0 && (triplet = ChangeTriplet.parse(id, y, z)).isPresent()) {
            ChangeTriplet t = triplet.get();
            return this.asChangeNotes(query.byBranchKey(t.branch(), t.id()));
        }
        return this.asChangeNotes(query.byKeyPrefix(id));
    }

    private List<ChangeNotes> fromProjectNumber(String project, int changeNumber) throws OrmException {
        Change.Id cId = new Change.Id(changeNumber);
        try {
            return ImmutableList.of(this.changeNotesFactory.createChecked(this.reviewDb.get(), Project.NameKey.parse(project), cId));
        }
        catch (NoSuchChangeException e) {
            return Collections.emptyList();
        }
        catch (OrmException e) {
            if (Throwables.getRootCause(e) instanceof RepositoryNotFoundException) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    public ChangeNotes findOne(Change.Id id) throws OrmException {
        List<ChangeNotes> notes = this.find(id);
        if (notes.size() != 1) {
            throw new NoSuchChangeException(id);
        }
        return notes.get(0);
    }

    public List<ChangeNotes> find(Change.Id id) throws OrmException {
        String project = this.changeIdProjectCache.getIfPresent(id);
        if (project != null) {
            return this.fromProjectNumber(project, id.get());
        }
        InternalChangeQuery query = this.queryProvider.get().noFields();
        List<ChangeData> r = query.byLegacyChangeId(id);
        if (r.size() == 1) {
            this.changeIdProjectCache.put(id, Url.encode(r.get(0).project().get()));
        }
        return this.asChangeNotes(r);
    }

    private List<ChangeNotes> asChangeNotes(List<ChangeData> cds) throws OrmException {
        ArrayList<ChangeNotes> notes = new ArrayList<ChangeNotes>(cds.size());
        if (!this.indexConfig.separateChangeSubIndexes()) {
            for (ChangeData cd : cds) {
                notes.add(cd.notes());
            }
            return notes;
        }
        HashSet<Change.Id> seen = Sets.newHashSetWithExpectedSize(cds.size());
        for (ChangeData cd : cds) {
            if (!seen.add(cd.getId())) continue;
            notes.add(cd.notes());
        }
        return notes;
    }
}

