/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.AvatarInfo;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.avatar.AvatarProvider;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

@Singleton
public class InternalAccountDirectory
extends AccountDirectory {
    static final Set<AccountDirectory.FillOptions> ID_ONLY = Collections.unmodifiableSet(EnumSet.of(AccountDirectory.FillOptions.ID));
    private final AccountCache accountCache;
    private final DynamicItem<AvatarProvider> avatar;
    private final IdentifiedUser.GenericFactory userFactory;

    @Inject
    InternalAccountDirectory(AccountCache accountCache, DynamicItem<AvatarProvider> avatar, IdentifiedUser.GenericFactory userFactory) {
        this.accountCache = accountCache;
        this.avatar = avatar;
        this.userFactory = userFactory;
    }

    @Override
    public void fillAccountInfo(Iterable<? extends AccountInfo> in, Set<AccountDirectory.FillOptions> options) throws AccountDirectory.DirectoryException {
        if (options.equals(ID_ONLY)) {
            return;
        }
        for (AccountInfo accountInfo : in) {
            Account.Id id = new Account.Id(accountInfo._accountId);
            AccountState state = this.accountCache.get(id);
            this.fill(accountInfo, state.getAccount(), state.getExternalIds(), options);
        }
    }

    private void fill(AccountInfo info, Account account, @Nullable Collection<ExternalId> externalIds, Set<AccountDirectory.FillOptions> options) {
        AvatarProvider ap;
        info._accountId = options.contains((Object)AccountDirectory.FillOptions.ID) ? Integer.valueOf(account.getId().get()) : null;
        if (options.contains((Object)AccountDirectory.FillOptions.NAME)) {
            info.name = Strings.emptyToNull(account.getFullName());
            if (info.name == null) {
                info.name = account.getUserName();
            }
        }
        if (options.contains((Object)AccountDirectory.FillOptions.EMAIL)) {
            info.email = account.getPreferredEmail();
        }
        if (options.contains((Object)AccountDirectory.FillOptions.SECONDARY_EMAILS)) {
            List<String> list = info.secondaryEmails = externalIds != null ? this.getSecondaryEmails(account, externalIds) : null;
        }
        if (options.contains((Object)AccountDirectory.FillOptions.USERNAME)) {
            String string = info.username = externalIds != null ? AccountState.getUserName(externalIds) : null;
        }
        if (options.contains((Object)AccountDirectory.FillOptions.STATUS)) {
            info.status = account.getStatus();
        }
        if (options.contains((Object)AccountDirectory.FillOptions.AVATARS) && (ap = this.avatar.get()) != null) {
            info.avatars = new ArrayList<AvatarInfo>(3);
            IdentifiedUser user = this.userFactory.create(account.getId());
            InternalAccountDirectory.addAvatar(ap, info, user, 26);
            if (!info.avatars.isEmpty()) {
                InternalAccountDirectory.addAvatar(ap, info, user, 32);
                InternalAccountDirectory.addAvatar(ap, info, user, 100);
            }
        }
    }

    public List<String> getSecondaryEmails(Account account, Collection<ExternalId> externalIds) {
        ArrayList<String> emails = new ArrayList<String>(AccountState.getEmails(externalIds));
        if (account.getPreferredEmail() != null) {
            emails.remove(account.getPreferredEmail());
        }
        Collections.sort(emails);
        return emails;
    }

    private static void addAvatar(AvatarProvider provider, AccountInfo account, IdentifiedUser user, int size) {
        String url = provider.getUrl(user, size);
        if (url != null) {
            AvatarInfo avatar = new AvatarInfo();
            avatar.url = url;
            avatar.height = size;
            account.avatars.add(avatar);
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind(AccountDirectory.class).to(InternalAccountDirectory.class);
        }
    }
}

