/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.AgreementInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.extensions.events.AgreementSignup;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

@Singleton
public class PutAgreement
implements RestModifyView<AccountResource, AgreementInput> {
    private final ProjectCache projectCache;
    private final Provider<IdentifiedUser> self;
    private final AgreementSignup agreementSignup;
    private final AddMembers addMembers;
    private final boolean agreementsEnabled;

    @Inject
    PutAgreement(ProjectCache projectCache, Provider<IdentifiedUser> self, AgreementSignup agreementSignup, AddMembers addMembers, @GerritServerConfig Config config) {
        this.projectCache = projectCache;
        this.self = self;
        this.agreementSignup = agreementSignup;
        this.addMembers = addMembers;
        this.agreementsEnabled = config.getBoolean("auth", "contributorAgreements", false);
    }

    public Response<String> apply(AccountResource resource, AgreementInput input) throws IOException, OrmException, RestApiException {
        if (!this.agreementsEnabled) {
            throw new MethodNotAllowedException("contributor agreements disabled");
        }
        if (!this.self.get().hasSameAccountId(resource.getUser())) {
            throw new AuthException("not allowed to enter contributor agreement");
        }
        String agreementName = Strings.nullToEmpty(input.name);
        ContributorAgreement ca = this.projectCache.getAllProjects().getConfig().getContributorAgreement(agreementName);
        if (ca == null) {
            throw new UnprocessableEntityException("contributor agreement not found");
        }
        if (ca.getAutoVerify() == null) {
            throw new BadRequestException("cannot enter a non-autoVerify agreement");
        }
        AccountGroup.UUID uuid = ca.getAutoVerify().getUUID();
        if (uuid == null) {
            throw new ResourceConflictException("autoverify group uuid not found");
        }
        Account account = this.self.get().getAccount();
        try {
            this.addMembers.addMembers(uuid, ImmutableList.of(account.getId()));
        }
        catch (NoSuchGroupException e) {
            throw new ResourceConflictException("autoverify group not found");
        }
        this.agreementSignup.fire(account, agreementName);
        return Response.ok(agreementName);
    }
}

