/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountsUpdate;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class SetInactiveFlag {
    private final AccountsUpdate.Server accountsUpdate;

    @Inject
    SetInactiveFlag(AccountsUpdate.Server accountsUpdate) {
        this.accountsUpdate = accountsUpdate;
    }

    public Response<?> deactivate(Account.Id accountId) throws RestApiException, IOException, ConfigInvalidException {
        AtomicBoolean alreadyInactive = new AtomicBoolean(false);
        Account account = this.accountsUpdate.create().update(accountId, a -> {
            if (!a.isActive()) {
                alreadyInactive.set(true);
            } else {
                a.setActive(false);
            }
        });
        if (account == null) {
            throw new ResourceNotFoundException("account not found");
        }
        if (alreadyInactive.get()) {
            throw new ResourceConflictException("account not active");
        }
        return Response.none();
    }

    public Response<String> activate(Account.Id accountId) throws ResourceNotFoundException, IOException, ConfigInvalidException {
        AtomicBoolean alreadyActive = new AtomicBoolean(false);
        Account account = this.accountsUpdate.create().update(accountId, a -> {
            if (a.isActive()) {
                alreadyActive.set(true);
            } else {
                a.setActive(true);
            }
        });
        if (account == null) {
            throw new ResourceNotFoundException("account not found");
        }
        return alreadyActive.get() ? Response.ok("") : Response.created("");
    }
}

