/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account.externalids;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer0;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExternalIdReader {
    private static final Logger log = LoggerFactory.getLogger(ExternalIdReader.class);
    public static final int MAX_NOTE_SZ = 524288;
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private boolean failOnLoad = false;
    private final Timer0 readAllLatency;

    public static ObjectId readRevision(Repository repo) throws IOException {
        Ref ref = repo.exactRef("refs/meta/external-ids");
        return ref != null ? ref.getObjectId() : ObjectId.zeroId();
    }

    public static NoteMap readNoteMap(RevWalk rw, ObjectId rev) throws IOException {
        if (!rev.equals(ObjectId.zeroId())) {
            return NoteMap.read(rw.getObjectReader(), rw.parseCommit(rev));
        }
        return NoteMap.newEmptyMap();
    }

    @Inject
    ExternalIdReader(GitRepositoryManager repoManager, AllUsersName allUsersName, MetricMaker metricMaker) {
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.readAllLatency = metricMaker.newTimer("notedb/read_all_external_ids_latency", new Description("Latency for reading all external IDs from NoteDb.").setCumulative().setUnit("milliseconds"));
    }

    @VisibleForTesting
    public void setFailOnLoad(boolean failOnLoad) {
        this.failOnLoad = failOnLoad;
    }

    ObjectId readRevision() throws IOException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            ObjectId objectId = ExternalIdReader.readRevision(repo);
            return objectId;
        }
    }

    Set<ExternalId> all() throws IOException {
        this.checkReadEnabled();
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            Set<ExternalId> set = this.all(repo, ExternalIdReader.readRevision(repo));
            return set;
        }
    }

    Set<ExternalId> all(ObjectId rev) throws IOException {
        this.checkReadEnabled();
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            Set<ExternalId> set = this.all(repo, rev);
            return set;
        }
    }

    private Set<ExternalId> all(Repository repo, ObjectId rev) throws IOException {
        if (rev.equals(ObjectId.zeroId())) {
            return ImmutableSet.of();
        }
        try (Timer0.Context ctx = this.readAllLatency.start();){
            RevWalk rw = new RevWalk(repo);
            try {
                NoteMap noteMap = ExternalIdReader.readNoteMap(rw, rev);
                HashSet<ExternalId> extIds = new HashSet<ExternalId>();
                for (Note note : noteMap) {
                    byte[] raw = rw.getObjectReader().open(note.getData(), 3).getCachedBytes(524288);
                    try {
                        extIds.add(ExternalId.parse(note.getName(), raw, note.getData()));
                    }
                    catch (Exception e) {
                        log.error("Ignoring invalid external ID note {}", (Object)note.getName(), (Object)e);
                    }
                }
                HashSet<ExternalId> hashSet = extIds;
                rw.close();
                return hashSet;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Nullable
    ExternalId get(ExternalId.Key key) throws IOException, ConfigInvalidException {
        this.checkReadEnabled();
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            ObjectId rev;
            RevWalk rw;
            block13: {
                rw = new RevWalk(repo);
                try {
                    rev = ExternalIdReader.readRevision(repo);
                    if (!rev.equals(ObjectId.zeroId())) break block13;
                    ExternalId externalId = null;
                    rw.close();
                    return externalId;
                }
                catch (Throwable throwable) {
                    try {
                        rw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ExternalId externalId = ExternalIdReader.parse(key, rw, rev);
            rw.close();
            return externalId;
        }
    }

    @Nullable
    ExternalId get(ExternalId.Key key, ObjectId rev) throws IOException, ConfigInvalidException {
        this.checkReadEnabled();
        if (rev.equals(ObjectId.zeroId())) {
            return null;
        }
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            RevWalk rw = new RevWalk(repo);
            try {
                ExternalId externalId = ExternalIdReader.parse(key, rw, rev);
                rw.close();
                return externalId;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static ExternalId parse(ExternalId.Key key, RevWalk rw, ObjectId rev) throws IOException, ConfigInvalidException {
        ObjectId noteId;
        NoteMap noteMap = ExternalIdReader.readNoteMap(rw, rev);
        if (!noteMap.contains(noteId = key.sha1())) {
            return null;
        }
        ObjectId noteData = noteMap.get(noteId);
        byte[] raw = rw.getObjectReader().open(noteData, 3).getCachedBytes(524288);
        return ExternalId.parse(noteId.name(), raw, noteData);
    }

    private void checkReadEnabled() throws IOException {
        if (this.failOnLoad) {
            throw new IOException("Reading from external IDs is disabled");
        }
    }
}

