/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.extensions.api.projects.BranchApi;
import com.google.gerrit.extensions.api.projects.BranchInfo;
import com.google.gerrit.extensions.api.projects.BranchInput;
import com.google.gerrit.extensions.api.projects.ReflogEntryInfo;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.BranchResource;
import com.google.gerrit.server.project.BranchesCollection;
import com.google.gerrit.server.project.CreateBranch;
import com.google.gerrit.server.project.DeleteBranch;
import com.google.gerrit.server.project.FileResource;
import com.google.gerrit.server.project.FilesCollection;
import com.google.gerrit.server.project.GetBranch;
import com.google.gerrit.server.project.GetContent;
import com.google.gerrit.server.project.GetReflog;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.List;

public class BranchApiImpl
implements BranchApi {
    private final BranchesCollection branches;
    private final CreateBranch.Factory createBranchFactory;
    private final DeleteBranch deleteBranch;
    private final FilesCollection filesCollection;
    private final GetBranch getBranch;
    private final GetContent getContent;
    private final GetReflog getReflog;
    private final String ref;
    private final ProjectResource project;

    @Inject
    BranchApiImpl(BranchesCollection branches, CreateBranch.Factory createBranchFactory, DeleteBranch deleteBranch, FilesCollection filesCollection, GetBranch getBranch, GetContent getContent, GetReflog getReflog, @Assisted ProjectResource project, @Assisted String ref) {
        this.branches = branches;
        this.createBranchFactory = createBranchFactory;
        this.deleteBranch = deleteBranch;
        this.filesCollection = filesCollection;
        this.getBranch = getBranch;
        this.getContent = getContent;
        this.getReflog = getReflog;
        this.project = project;
        this.ref = ref;
    }

    @Override
    public BranchApi create(BranchInput input) throws RestApiException {
        try {
            this.createBranchFactory.create(this.ref).apply(this.project, input);
            return this;
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot create branch", e);
        }
    }

    @Override
    public BranchInfo get() throws RestApiException {
        try {
            return this.getBranch.apply(this.resource());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot read branch", e);
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteBranch.apply(this.resource(), new DeleteBranch.Input());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete branch", e);
        }
    }

    @Override
    public BinaryResult file(String path) throws RestApiException {
        try {
            FileResource resource = this.filesCollection.parse(this.resource(), IdString.fromDecoded(path));
            return this.getContent.apply(resource);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve file", e);
        }
    }

    @Override
    public List<ReflogEntryInfo> reflog() throws RestApiException {
        try {
            return this.getReflog.apply(this.resource());
        }
        catch (PermissionBackendException | IOException e) {
            throw new RestApiException("Cannot retrieve reflog", e);
        }
    }

    private BranchResource resource() throws RestApiException, IOException, PermissionBackendException {
        return this.branches.parse(this.project, IdString.fromDecoded(this.ref));
    }

    static interface Factory {
        public BranchApiImpl create(ProjectResource var1, String var2);
    }
}

