/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.oauth;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.gerrit.extensions.auth.oauth.OAuthToken;
import com.google.gerrit.extensions.auth.oauth.OAuthTokenEncrypter;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.cache.CacheModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;

@Singleton
public class OAuthTokenCache {
    public static final String OAUTH_TOKENS = "oauth_tokens";
    private final DynamicItem<OAuthTokenEncrypter> encrypter;
    private final Cache<Account.Id, OAuthToken> cache;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.persist(OAuthTokenCache.OAUTH_TOKENS, Account.Id.class, OAuthToken.class);
            }
        };
    }

    @Inject
    OAuthTokenCache(@Named(value="oauth_tokens") Cache<Account.Id, OAuthToken> cache, DynamicItem<OAuthTokenEncrypter> encrypter) {
        this.cache = cache;
        this.encrypter = encrypter;
    }

    public OAuthToken get(Account.Id id) {
        OAuthToken accessToken = this.cache.getIfPresent(id);
        if (accessToken == null) {
            return null;
        }
        if ((accessToken = this.decrypt(accessToken)).isExpired()) {
            this.cache.invalidate(id);
            return null;
        }
        return accessToken;
    }

    public void put(Account.Id id, OAuthToken accessToken) {
        this.cache.put(id, this.encrypt(Preconditions.checkNotNull(accessToken)));
    }

    public void remove(Account.Id id) {
        this.cache.invalidate(id);
    }

    private OAuthToken encrypt(OAuthToken token) {
        OAuthTokenEncrypter enc = this.encrypter.get();
        if (enc == null) {
            return token;
        }
        return enc.encrypt(token);
    }

    private OAuthToken decrypt(OAuthToken token) {
        OAuthTokenEncrypter enc = this.encrypter.get();
        if (enc == null) {
            return token;
        }
        return enc.decrypt(token);
    }
}

