/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.CherryPickInput;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class CherryPickChange {
    private final Provider<ReviewDb> dbProvider;
    private final Sequences seq;
    private final Provider<InternalChangeQuery> queryProvider;
    private final GitRepositoryManager gitManager;
    private final TimeZone serverTimeZone;
    private final Provider<IdentifiedUser> user;
    private final ChangeInserter.Factory changeInserterFactory;
    private final PatchSetInserter.Factory patchSetInserterFactory;
    private final MergeUtil.Factory mergeUtilFactory;
    private final ChangeNotes.Factory changeNotesFactory;
    private final ProjectControl.GenericFactory projectControlFactory;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeMessagesUtil changeMessagesUtil;
    private final NotifyUtil notifyUtil;

    @Inject
    CherryPickChange(Provider<ReviewDb> dbProvider, Sequences seq, Provider<InternalChangeQuery> queryProvider, @GerritPersonIdent PersonIdent myIdent, GitRepositoryManager gitManager, Provider<IdentifiedUser> user, ChangeInserter.Factory changeInserterFactory, PatchSetInserter.Factory patchSetInserterFactory, MergeUtil.Factory mergeUtilFactory, ChangeNotes.Factory changeNotesFactory, ProjectControl.GenericFactory projectControlFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil changeMessagesUtil, NotifyUtil notifyUtil) {
        this.dbProvider = dbProvider;
        this.seq = seq;
        this.queryProvider = queryProvider;
        this.gitManager = gitManager;
        this.serverTimeZone = myIdent.getTimeZone();
        this.user = user;
        this.changeInserterFactory = changeInserterFactory;
        this.patchSetInserterFactory = patchSetInserterFactory;
        this.mergeUtilFactory = mergeUtilFactory;
        this.changeNotesFactory = changeNotesFactory;
        this.projectControlFactory = projectControlFactory;
        this.approvalsUtil = approvalsUtil;
        this.changeMessagesUtil = changeMessagesUtil;
        this.notifyUtil = notifyUtil;
    }

    public Change.Id cherryPick(BatchUpdate.Factory batchUpdateFactory, Change change, PatchSet patch, CherryPickInput input, Branch.NameKey dest) throws OrmException, IOException, InvalidChangeOperationException, IntegrationException, UpdateException, RestApiException, ConfigInvalidException, NoSuchProjectException {
        return this.cherryPick(batchUpdateFactory, change, patch.getId(), change.getProject(), ObjectId.fromString(patch.getRevision().get()), input, dest);
    }

    /*
     * Exception decompiling
     */
    public Change.Id cherryPick(BatchUpdate.Factory batchUpdateFactory, @Nullable Change sourceChange, @Nullable PatchSet.Id sourcePatchId, Project.NameKey project, ObjectId sourceCommit, CherryPickInput input, Branch.NameKey dest) throws OrmException, IOException, InvalidChangeOperationException, IntegrationException, UpdateException, RestApiException, ConfigInvalidException, NoSuchProjectException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RevCommit getBaseCommit(Ref destRef, String project, RevWalk revWalk, String base) throws RestApiException, IOException, OrmException {
        ObjectId baseObjectId;
        RevCommit destRefTip = revWalk.parseCommit(destRef.getObjectId());
        if (Strings.isNullOrEmpty(base)) {
            return destRefTip;
        }
        try {
            baseObjectId = ObjectId.fromString(base);
        }
        catch (InvalidObjectIdException e) {
            throw new BadRequestException(String.format("Base %s doesn't represent a valid SHA-1", base));
        }
        RevCommit baseCommit = revWalk.parseCommit(baseObjectId);
        InternalChangeQuery changeQuery = this.queryProvider.get();
        changeQuery.enforceVisibility(true);
        List<ChangeData> changeDatas = changeQuery.byBranchCommit(project, destRef.getName(), base);
        if (changeDatas.isEmpty()) {
            if (revWalk.isMergedInto(baseCommit, destRefTip)) {
                return baseCommit;
            }
            throw new UnprocessableEntityException(String.format("Commit %s does not exist on branch %s", base, destRef.getName()));
        }
        if (changeDatas.size() != 1) {
            throw new ResourceConflictException("Multiple changes found for commit " + base);
        }
        Change change = changeDatas.get(0).change();
        Change.Status status = change.getStatus();
        if (status == Change.Status.NEW || status == Change.Status.MERGED) {
            return baseCommit;
        }
        throw new ResourceConflictException(String.format("Change %s with commit %s is %s", new Object[]{change.getChangeId(), base, status.asChangeStatus()}));
    }

    private Change.Id insertPatchSet(BatchUpdate bu, Repository git, ChangeNotes destNotes, CodeReviewCommit cherryPickCommit, CherryPickInput input) throws IOException, OrmException, BadRequestException, ConfigInvalidException {
        Change destChange = destNotes.getChange();
        PatchSet.Id psId = ChangeUtil.nextPatchSetId(git, destChange.currentPatchSetId());
        PatchSetInserter inserter = this.patchSetInserterFactory.create(destNotes, psId, cherryPickCommit);
        inserter.setMessage("Uploaded patch set " + inserter.getPatchSetId().get() + ".").setNotify(input.notify).setAccountsToNotify(this.notifyUtil.resolveAccounts(input.notifyDetails));
        bu.addOp(destChange.getId(), inserter);
        return destChange.getId();
    }

    private Change.Id createNewChange(BatchUpdate bu, CodeReviewCommit cherryPickCommit, String refName, String topic, @Nullable Change sourceChange, ObjectId sourceCommit, CherryPickInput input) throws OrmException, IOException, BadRequestException, ConfigInvalidException {
        Change.Id changeId = new Change.Id(this.seq.nextChangeId());
        ChangeInserter ins = this.changeInserterFactory.create(changeId, cherryPickCommit, refName);
        Branch.NameKey sourceBranch = sourceChange == null ? null : sourceChange.getDest();
        ins.setMessage(this.messageForDestinationChange(ins.getPatchSetId(), sourceBranch, sourceCommit)).setTopic(topic).setWorkInProgress(sourceChange != null && sourceChange.isWorkInProgress()).setNotify(input.notify).setAccountsToNotify(this.notifyUtil.resolveAccounts(input.notifyDetails));
        if (input.keepReviewers && sourceChange != null) {
            ReviewerSet reviewerSet = this.approvalsUtil.getReviewers(this.dbProvider.get(), this.changeNotesFactory.createChecked(this.dbProvider.get(), sourceChange));
            HashSet<Account.Id> reviewers = new HashSet<Account.Id>(reviewerSet.byState(ReviewerStateInternal.REVIEWER));
            reviewers.add(sourceChange.getOwner());
            reviewers.remove(this.user.get().getAccountId());
            HashSet<Account.Id> ccs = new HashSet<Account.Id>(reviewerSet.byState(ReviewerStateInternal.CC));
            ccs.remove(this.user.get().getAccountId());
            ins.setReviewers(reviewers).setExtraCC(ccs);
        }
        bu.insertChange(ins);
        return changeId;
    }

    private String messageForDestinationChange(PatchSet.Id patchSetId, Branch.NameKey sourceBranch, ObjectId sourceCommit) {
        StringBuilder stringBuilder = new StringBuilder("Patch Set ").append(patchSetId.get());
        if (sourceBranch != null) {
            stringBuilder.append(": Cherry Picked from branch ").append(sourceBranch.getShortName());
        } else {
            stringBuilder.append(": Cherry Picked from commit ").append(sourceCommit.getName());
        }
        return stringBuilder.append(".").toString();
    }

    private static class AddMessageToSourceChangeOp
    implements BatchUpdateOp {
        private final ChangeMessagesUtil cmUtil;
        private final PatchSet.Id psId;
        private final String destBranch;
        private final ObjectId cherryPickCommit;

        private AddMessageToSourceChangeOp(ChangeMessagesUtil cmUtil, PatchSet.Id psId, String destBranch, ObjectId cherryPickCommit) {
            this.cmUtil = cmUtil;
            this.psId = psId;
            this.destBranch = destBranch;
            this.cherryPickCommit = cherryPickCommit;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException {
            StringBuilder sb = new StringBuilder("Patch Set ").append(this.psId.get()).append(": Cherry Picked").append("\n\n").append("This patchset was cherry picked to branch ").append(this.destBranch).append(" as commit ").append(this.cherryPickCommit.name());
            ChangeMessage changeMessage = ChangeMessagesUtil.newMessage(this.psId, ctx.getUser(), ctx.getWhen(), sb.toString(), "autogenerated:gerrit:cherryPickChange");
            this.cmUtil.addChangeMessage(ctx.getDb(), ctx.getUpdate(this.psId), changeMessage);
            return true;
        }
    }
}

