/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.common.ChangeType;
import com.google.gerrit.extensions.common.DiffInfo;
import com.google.gerrit.extensions.common.DiffWebLinkInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.change.FileContentUtil;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.git.LargeObjectException;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.PatchScriptFactory;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.ReplaceEdit;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class GetDiff
implements RestReadView<FileResource> {
    private static final ImmutableMap<Patch.ChangeType, ChangeType> CHANGE_TYPE = Maps.immutableEnumMap(new ImmutableMap.Builder<Patch.ChangeType, ChangeType>().put(Patch.ChangeType.ADDED, ChangeType.ADDED).put(Patch.ChangeType.MODIFIED, ChangeType.MODIFIED).put(Patch.ChangeType.DELETED, ChangeType.DELETED).put(Patch.ChangeType.RENAMED, ChangeType.RENAMED).put(Patch.ChangeType.COPIED, ChangeType.COPIED).put(Patch.ChangeType.REWRITE, ChangeType.REWRITE).build());
    private final ProjectCache projectCache;
    private final PatchScriptFactory.Factory patchScriptFactoryFactory;
    private final Revisions revisions;
    private final WebLinks webLinks;
    @Option(name="--base", metaVar="REVISION")
    String base;
    @Option(name="--parent", metaVar="parent-number")
    int parentNum;
    @Deprecated
    @Option(name="--ignore-whitespace")
    IgnoreWhitespace ignoreWhitespace;
    @Option(name="--whitespace")
    DiffPreferencesInfo.Whitespace whitespace;
    @Option(name="--context", handler=ContextOptionHandler.class)
    int context = 10;
    @Option(name="--intraline")
    boolean intraline;
    @Option(name="--weblinks-only")
    boolean webLinksOnly;

    @Inject
    GetDiff(ProjectCache projectCache, PatchScriptFactory.Factory patchScriptFactoryFactory, Revisions revisions, WebLinks webLinks) {
        this.projectCache = projectCache;
        this.patchScriptFactoryFactory = patchScriptFactoryFactory;
        this.revisions = revisions;
        this.webLinks = webLinks;
    }

    public Response<DiffInfo> apply(FileResource resource) throws ResourceConflictException, ResourceNotFoundException, OrmException, AuthException, InvalidChangeOperationException, IOException, PermissionBackendException {
        PatchScriptFactory psf;
        DiffPreferencesInfo prefs = new DiffPreferencesInfo();
        prefs.ignoreWhitespace = this.whitespace != null ? this.whitespace : (this.ignoreWhitespace != null ? this.ignoreWhitespace.whitespace : DiffPreferencesInfo.Whitespace.IGNORE_LEADING_AND_TRAILING);
        prefs.context = this.context;
        prefs.intralineDifference = this.intraline;
        PatchSet basePatchSet = null;
        PatchSet.Id pId = resource.getPatchKey().getParentKey();
        String fileName = resource.getPatchKey().getFileName();
        ChangeNotes notes = resource.getRevision().getNotes();
        if (this.base != null) {
            RevisionResource baseResource = this.revisions.parse(resource.getRevision().getChangeResource(), IdString.fromDecoded(this.base));
            basePatchSet = baseResource.getPatchSet();
            psf = this.patchScriptFactoryFactory.create(notes, fileName, basePatchSet.getId(), pId, prefs);
        } else {
            psf = this.parentNum > 0 ? this.patchScriptFactoryFactory.create(notes, fileName, this.parentNum - 1, pId, prefs) : this.patchScriptFactoryFactory.create(notes, fileName, null, pId, prefs);
        }
        try {
            psf.setLoadHistory(false);
            psf.setLoadComments(this.context != -1);
            PatchScript ps = psf.call();
            Content content = new Content(ps);
            Set<Edit> editsDueToRebase = ps.getEditsDueToRebase();
            block6: for (Edit edit : ps.getEdits()) {
                if (edit.getType() == Edit.Type.EMPTY) continue;
                content.addCommon(edit.getBeginA());
                Preconditions.checkState(content.nextA == edit.getBeginA(), "nextA = %s; want %s", content.nextA, edit.getBeginA());
                Preconditions.checkState(content.nextB == edit.getBeginB(), "nextB = %s; want %s", content.nextB, edit.getBeginB());
                switch (edit.getType()) {
                    case DELETE: 
                    case INSERT: 
                    case REPLACE: {
                        List<Edit> internalEdit = edit instanceof ReplaceEdit ? ((ReplaceEdit)edit).getInternalEdits() : null;
                        boolean dueToRebase = editsDueToRebase.contains(edit);
                        content.addDiff(edit.getEndA(), edit.getEndB(), internalEdit, dueToRebase);
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
            content.addCommon(ps.getA().size());
            ProjectState state = this.projectCache.get(resource.getRevision().getChange().getProject());
            DiffInfo result = new DiffInfo();
            String revA = basePatchSet != null ? basePatchSet.getRefName() : content.commitIdA;
            String revB = resource.getRevision().getEdit().isPresent() ? resource.getRevision().getEdit().get().getRefName() : resource.getRevision().getPatchSet().getRefName();
            List<DiffWebLinkInfo> links = this.webLinks.getDiffLinks(state.getName(), resource.getPatchKey().getParentKey().getParentKey().get(), basePatchSet != null ? Integer.valueOf(basePatchSet.getId().get()) : null, revA, MoreObjects.firstNonNull(ps.getOldName(), ps.getNewName()), resource.getPatchKey().getParentKey().get(), revB, ps.getNewName());
            List<DiffWebLinkInfo> list = result.webLinks = links.isEmpty() ? null : links;
            if (!this.webLinksOnly) {
                if (ps.isBinary()) {
                    result.binary = true;
                }
                if (ps.getDisplayMethodA() != PatchScript.DisplayMethod.NONE) {
                    result.metaA = new DiffInfo.FileMeta();
                    result.metaA.name = MoreObjects.firstNonNull(ps.getOldName(), ps.getNewName());
                    result.metaA.contentType = FileContentUtil.resolveContentType(state, result.metaA.name, ps.getFileModeA(), ps.getMimeTypeA());
                    result.metaA.lines = ps.getA().size();
                    result.metaA.webLinks = this.getFileWebLinks(state.getProject(), revA, result.metaA.name);
                    result.metaA.commitId = content.commitIdA;
                }
                if (ps.getDisplayMethodB() != PatchScript.DisplayMethod.NONE) {
                    result.metaB = new DiffInfo.FileMeta();
                    result.metaB.name = ps.getNewName();
                    result.metaB.contentType = FileContentUtil.resolveContentType(state, result.metaB.name, ps.getFileModeB(), ps.getMimeTypeB());
                    result.metaB.lines = ps.getB().size();
                    result.metaB.webLinks = this.getFileWebLinks(state.getProject(), revB, result.metaB.name);
                    result.metaB.commitId = content.commitIdB;
                }
                if (this.intraline) {
                    result.intralineStatus = ps.hasIntralineTimeout() ? DiffInfo.IntraLineStatus.TIMEOUT : (ps.hasIntralineFailure() ? DiffInfo.IntraLineStatus.FAILURE : DiffInfo.IntraLineStatus.OK);
                }
                result.changeType = CHANGE_TYPE.get(ps.getChangeType());
                if (result.changeType == null) {
                    throw new IllegalStateException("unknown change type: " + ps.getChangeType());
                }
                if (ps.getPatchHeader().size() > 0) {
                    result.diffHeader = ps.getPatchHeader();
                }
                result.content = content.lines;
            }
            Response<DiffInfo> r = Response.ok(result);
            if (resource.isCacheable()) {
                r.caching(CacheControl.PRIVATE(7L, TimeUnit.DAYS));
            }
            return r;
        }
        catch (NoSuchChangeException e) {
            throw new ResourceNotFoundException(e.getMessage(), e);
        }
        catch (LargeObjectException e) {
            throw new ResourceConflictException(e.getMessage(), e);
        }
    }

    private List<WebLinkInfo> getFileWebLinks(Project project, String rev, String file) {
        List<WebLinkInfo> links = this.webLinks.getFileLinks(project.getName(), rev, file);
        return links.isEmpty() ? null : links;
    }

    public GetDiff setBase(String base) {
        this.base = base;
        return this;
    }

    public GetDiff setParent(int parentNum) {
        this.parentNum = parentNum;
        return this;
    }

    public GetDiff setContext(int context) {
        this.context = context;
        return this;
    }

    public GetDiff setIntraline(boolean intraline) {
        this.intraline = intraline;
        return this;
    }

    public GetDiff setWhitespace(DiffPreferencesInfo.Whitespace whitespace) {
        this.whitespace = whitespace;
        return this;
    }

    public static class ContextOptionHandler
    extends OptionHandler<Short> {
        public ContextOptionHandler(CmdLineParser parser, OptionDef option, Setter<Short> setter) {
            super(parser, option, setter);
        }

        @Override
        public final int parseArguments(Parameters params) throws CmdLineException {
            short context;
            String value = params.getParameter(0);
            if ("all".equalsIgnoreCase(value)) {
                context = -1;
            } else {
                try {
                    context = Short.parseShort(value, 10);
                    if (context < 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmdLineException(this.owner, String.format("\"%s\" is not a valid value for \"%s\"", value, ((NamedOptionDef)this.option).name()));
                }
            }
            this.setter.addValue(context);
            return 1;
        }

        @Override
        public final String getDefaultMetaVariable() {
            return "ALL|# LINES";
        }
    }

    @Deprecated
    static enum IgnoreWhitespace {
        NONE(DiffPreferencesInfo.Whitespace.IGNORE_NONE),
        TRAILING(DiffPreferencesInfo.Whitespace.IGNORE_TRAILING),
        CHANGED(DiffPreferencesInfo.Whitespace.IGNORE_LEADING_AND_TRAILING),
        ALL(DiffPreferencesInfo.Whitespace.IGNORE_ALL);

        private final DiffPreferencesInfo.Whitespace whitespace;

        private IgnoreWhitespace(DiffPreferencesInfo.Whitespace whitespace) {
            this.whitespace = whitespace;
        }
    }

    private static class Content {
        final List<DiffInfo.ContentEntry> lines;
        final SparseFileContent fileA;
        final SparseFileContent fileB;
        final boolean ignoreWS;
        final String commitIdA;
        final String commitIdB;
        int nextA;
        int nextB;

        Content(PatchScript ps) {
            this.lines = Lists.newArrayListWithExpectedSize(ps.getEdits().size() + 2);
            this.fileA = ps.getA();
            this.fileB = ps.getB();
            this.ignoreWS = ps.isIgnoreWhitespace();
            this.commitIdA = ps.getCommitIdA();
            this.commitIdB = ps.getCommitIdB();
        }

        void addCommon(int end) {
            if (this.nextA >= (end = Math.min(end, this.fileA.size()))) {
                return;
            }
            while (this.nextA < end) {
                if (!this.fileA.contains(this.nextA)) {
                    int endRegion = Math.min(end, this.nextA == 0 ? this.fileA.first() : this.fileA.next(this.nextA - 1));
                    int len = endRegion - this.nextA;
                    this.entry().skip = len;
                    this.nextA = endRegion;
                    this.nextB += len;
                    continue;
                }
                DiffInfo.ContentEntry e = null;
                int i = this.nextA;
                while (i == this.nextA && i < end) {
                    if (this.ignoreWS && this.fileB.contains(this.nextB)) {
                        if (e == null || e.common == null) {
                            e = this.entry();
                            e.a = Lists.newArrayListWithCapacity(end - this.nextA);
                            e.b = Lists.newArrayListWithCapacity(end - this.nextA);
                            e.common = true;
                        }
                        e.a.add(this.fileA.get(this.nextA));
                        e.b.add(this.fileB.get(this.nextB));
                    } else {
                        if (e == null || e.common != null) {
                            e = this.entry();
                            e.ab = Lists.newArrayListWithCapacity(end - this.nextA);
                        }
                        e.ab.add(this.fileA.get(this.nextA));
                    }
                    i = this.fileA.next(i);
                    ++this.nextA;
                    ++this.nextB;
                }
            }
        }

        void addDiff(int endA, int endB, List<Edit> internalEdit, boolean dueToRebase) {
            int lenA = endA - this.nextA;
            int lenB = endB - this.nextB;
            Preconditions.checkState(lenA > 0 || lenB > 0);
            DiffInfo.ContentEntry e = this.entry();
            if (lenA > 0) {
                e.a = Lists.newArrayListWithCapacity(lenA);
                while (this.nextA < endA) {
                    e.a.add(this.fileA.get(this.nextA));
                    ++this.nextA;
                }
            }
            if (lenB > 0) {
                e.b = Lists.newArrayListWithCapacity(lenB);
                while (this.nextB < endB) {
                    e.b.add(this.fileB.get(this.nextB));
                    ++this.nextB;
                }
            }
            if (internalEdit != null && !internalEdit.isEmpty()) {
                e.editA = Lists.newArrayListWithCapacity(internalEdit.size() * 2);
                e.editB = Lists.newArrayListWithCapacity(internalEdit.size() * 2);
                int lastA = 0;
                int lastB = 0;
                for (Edit edit : internalEdit) {
                    if (edit.getBeginA() != edit.getEndA()) {
                        e.editA.add(ImmutableList.of(Integer.valueOf(edit.getBeginA() - lastA), Integer.valueOf(edit.getEndA() - edit.getBeginA())));
                        lastA = edit.getEndA();
                    }
                    if (edit.getBeginB() == edit.getEndB()) continue;
                    e.editB.add(ImmutableList.of(Integer.valueOf(edit.getBeginB() - lastB), Integer.valueOf(edit.getEndB() - edit.getBeginB())));
                    lastB = edit.getEndB();
                }
            }
            e.dueToRebase = dueToRebase ? Boolean.valueOf(true) : null;
        }

        private DiffInfo.ContentEntry entry() {
            DiffInfo.ContentEntry e = new DiffInfo.ContentEntry();
            this.lines.add(e);
            return e;
        }
    }
}

