/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;

@Singleton
public class ListRevisionDrafts
implements RestReadView<RevisionResource> {
    protected final Provider<ReviewDb> db;
    protected final Provider<CommentJson> commentJson;
    protected final CommentsUtil commentsUtil;

    @Inject
    ListRevisionDrafts(Provider<ReviewDb> db, Provider<CommentJson> commentJson, CommentsUtil commentsUtil) {
        this.db = db;
        this.commentJson = commentJson;
        this.commentsUtil = commentsUtil;
    }

    protected Iterable<Comment> listComments(RevisionResource rsrc) throws OrmException {
        return this.commentsUtil.draftByPatchSetAuthor(this.db.get(), rsrc.getPatchSet().getId(), rsrc.getAccountId(), rsrc.getNotes());
    }

    protected boolean includeAuthorInfo() {
        return false;
    }

    public Map<String, List<CommentInfo>> apply(RevisionResource rsrc) throws OrmException {
        return this.commentJson.get().setFillAccounts(this.includeAuthorInfo()).newCommentFormatter().format(this.listComments(rsrc));
    }

    public List<CommentInfo> getComments(RevisionResource rsrc) throws OrmException {
        return this.commentJson.get().setFillAccounts(this.includeAuthorInfo()).newCommentFormatter().formatAsList(this.listComments(rsrc));
    }
}

