/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.restapi.MergeConflictException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.change.RebaseUtil;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RepoContext;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class RebaseChangeOp
implements BatchUpdateOp {
    private final PatchSetInserter.Factory patchSetInserterFactory;
    private final MergeUtil.Factory mergeUtilFactory;
    private final RebaseUtil rebaseUtil;
    private final ChangeResource.Factory changeResourceFactory;
    private final ChangeNotes notes;
    private final PatchSet originalPatchSet;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final ProjectCache projectCache;
    private ObjectId baseCommitId;
    private PersonIdent committerIdent;
    private boolean fireRevisionCreated = true;
    private boolean validate = true;
    private boolean checkAddPatchSetPermission = true;
    private boolean forceContentMerge;
    private boolean copyApprovals = true;
    private boolean detailedCommitMessage;
    private boolean postMessage = true;
    private boolean matchAuthorToCommitterDate = false;
    private RevCommit rebasedCommit;
    private PatchSet.Id rebasedPatchSetId;
    private PatchSetInserter patchSetInserter;
    private PatchSet rebasedPatchSet;

    @Inject
    RebaseChangeOp(PatchSetInserter.Factory patchSetInserterFactory, MergeUtil.Factory mergeUtilFactory, RebaseUtil rebaseUtil, ChangeResource.Factory changeResourceFactory, IdentifiedUser.GenericFactory identifiedUserFactory, ProjectCache projectCache, @Assisted ChangeNotes notes, @Assisted PatchSet originalPatchSet, @Assisted ObjectId baseCommitId) {
        this.patchSetInserterFactory = patchSetInserterFactory;
        this.mergeUtilFactory = mergeUtilFactory;
        this.rebaseUtil = rebaseUtil;
        this.changeResourceFactory = changeResourceFactory;
        this.identifiedUserFactory = identifiedUserFactory;
        this.projectCache = projectCache;
        this.notes = notes;
        this.originalPatchSet = originalPatchSet;
        this.baseCommitId = baseCommitId;
    }

    public RebaseChangeOp setCommitterIdent(PersonIdent committerIdent) {
        this.committerIdent = committerIdent;
        return this;
    }

    public RebaseChangeOp setValidate(boolean validate) {
        this.validate = validate;
        return this;
    }

    public RebaseChangeOp setCheckAddPatchSetPermission(boolean checkAddPatchSetPermission) {
        this.checkAddPatchSetPermission = checkAddPatchSetPermission;
        return this;
    }

    public RebaseChangeOp setFireRevisionCreated(boolean fireRevisionCreated) {
        this.fireRevisionCreated = fireRevisionCreated;
        return this;
    }

    public RebaseChangeOp setForceContentMerge(boolean forceContentMerge) {
        this.forceContentMerge = forceContentMerge;
        return this;
    }

    public RebaseChangeOp setCopyApprovals(boolean copyApprovals) {
        this.copyApprovals = copyApprovals;
        return this;
    }

    public RebaseChangeOp setDetailedCommitMessage(boolean detailedCommitMessage) {
        this.detailedCommitMessage = detailedCommitMessage;
        return this;
    }

    public RebaseChangeOp setPostMessage(boolean postMessage) {
        this.postMessage = postMessage;
        return this;
    }

    public RebaseChangeOp setMatchAuthorToCommitterDate(boolean matchAuthorToCommitterDate) {
        this.matchAuthorToCommitterDate = matchAuthorToCommitterDate;
        return this;
    }

    @Override
    public void updateRepo(RepoContext ctx) throws MergeConflictException, InvalidChangeOperationException, RestApiException, IOException, OrmException, NoSuchChangeException, PermissionBackendException {
        String newCommitMessage;
        RevId oldRev = this.originalPatchSet.getRevision();
        RevWalk rw = ctx.getRevWalk();
        RevCommit original = rw.parseCommit(ObjectId.fromString(oldRev.get()));
        rw.parseBody(original);
        RevCommit baseCommit = rw.parseCommit(this.baseCommitId);
        IdentifiedUser changeOwner = this.identifiedUserFactory.create(this.notes.getChange().getOwner());
        if (this.detailedCommitMessage) {
            rw.parseBody(baseCommit);
            newCommitMessage = this.newMergeUtil().createCommitMessageOnSubmit(original, baseCommit, this.notes, changeOwner, this.originalPatchSet.getId());
        } else {
            newCommitMessage = original.getFullMessage();
        }
        this.rebasedCommit = this.rebaseCommit(ctx, original, baseCommit, newCommitMessage);
        RebaseUtil.Base base = this.rebaseUtil.parseBase(new RevisionResource(this.changeResourceFactory.create(this.notes, changeOwner), this.originalPatchSet), this.baseCommitId.name());
        this.rebasedPatchSetId = ChangeUtil.nextPatchSetIdFromChangeRefsMap(ctx.getRepoView().getRefs(this.originalPatchSet.getId().getParentKey().toRefPrefix()), this.notes.getChange().currentPatchSetId());
        this.patchSetInserter = this.patchSetInserterFactory.create(this.notes, this.rebasedPatchSetId, this.rebasedCommit).setDescription("Rebase").setNotify(NotifyHandling.NONE).setFireRevisionCreated(this.fireRevisionCreated).setCopyApprovals(this.copyApprovals).setCheckAddPatchSetPermission(this.checkAddPatchSetPermission).setValidate(this.validate);
        if (this.postMessage) {
            this.patchSetInserter.setMessage("Patch Set " + this.rebasedPatchSetId.get() + ": Patch Set " + this.originalPatchSet.getId().get() + " was rebased");
        }
        if (base != null) {
            this.patchSetInserter.setGroups(base.patchSet().getGroups());
        }
        this.patchSetInserter.updateRepo(ctx);
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws ResourceConflictException, OrmException, IOException {
        boolean ret = this.patchSetInserter.updateChange(ctx);
        this.rebasedPatchSet = this.patchSetInserter.getPatchSet();
        return ret;
    }

    @Override
    public void postUpdate(Context ctx) throws OrmException {
        this.patchSetInserter.postUpdate(ctx);
    }

    public RevCommit getRebasedCommit() {
        Preconditions.checkState(this.rebasedCommit != null, "getRebasedCommit() only valid after updateRepo");
        return this.rebasedCommit;
    }

    public PatchSet.Id getPatchSetId() {
        Preconditions.checkState(this.rebasedPatchSetId != null, "getPatchSetId() only valid after updateRepo");
        return this.rebasedPatchSetId;
    }

    public PatchSet getPatchSet() {
        Preconditions.checkState(this.rebasedPatchSet != null, "getPatchSet() only valid after executing update");
        return this.rebasedPatchSet;
    }

    private MergeUtil newMergeUtil() throws IOException {
        ProjectState project = this.projectCache.checkedGet(this.notes.getProjectName());
        return this.forceContentMerge ? this.mergeUtilFactory.create(project, true) : this.mergeUtilFactory.create(project);
    }

    private RevCommit rebaseCommit(RepoContext ctx, RevCommit original, ObjectId base, String commitMessage) throws ResourceConflictException, IOException {
        RevCommit parentCommit = original.getParent(0);
        if (base.equals(parentCommit)) {
            throw new ResourceConflictException("Change is already up to date.");
        }
        ThreeWayMerger merger = this.newMergeUtil().newThreeWayMerger(ctx.getInserter(), ctx.getRepoView().getConfig());
        merger.setBase(parentCommit);
        boolean success = merger.merge(original, base);
        if (!success || merger.getResultTreeId() == null) {
            throw new MergeConflictException("The change could not be rebased due to a conflict during merge.");
        }
        CommitBuilder cb = new CommitBuilder();
        cb.setTreeId(merger.getResultTreeId());
        cb.setParentId(base);
        cb.setAuthor(original.getAuthorIdent());
        cb.setMessage(commitMessage);
        if (this.committerIdent != null) {
            cb.setCommitter(this.committerIdent);
        } else {
            cb.setCommitter(ctx.getIdentifiedUser().newCommitterIdent(ctx.getWhen(), ctx.getTimeZone()));
        }
        if (this.matchAuthorToCommitterDate) {
            cb.setAuthor(new PersonIdent(cb.getAuthor(), cb.getCommitter().getWhen(), cb.getCommitter().getTimeZone()));
        }
        ObjectId objectId = ctx.getInserter().insert(cb);
        ctx.getInserter().flush();
        return ctx.getRevWalk().parseCommit(objectId);
    }

    public static interface Factory {
        public RebaseChangeOp create(ChangeNotes var1, PatchSet var2, ObjectId var3);
    }
}

