/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.mail.EmailTokenVerifier;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class ConfirmEmail
implements RestModifyView<ConfigResource, Input> {
    private final Provider<CurrentUser> self;
    private final EmailTokenVerifier emailTokenVerifier;
    private final AccountManager accountManager;

    @Inject
    public ConfirmEmail(Provider<CurrentUser> self, EmailTokenVerifier emailTokenVerifier, AccountManager accountManager) {
        this.self = self;
        this.emailTokenVerifier = emailTokenVerifier;
        this.accountManager = accountManager;
    }

    public Response<?> apply(ConfigResource rsrc, Input input) throws AuthException, UnprocessableEntityException, AccountException, OrmException, IOException, ConfigInvalidException {
        CurrentUser user = this.self.get();
        if (!user.isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        if (input == null) {
            input = new Input();
        }
        if (input.token == null) {
            throw new UnprocessableEntityException("missing token");
        }
        try {
            EmailTokenVerifier.ParsedToken token = this.emailTokenVerifier.decode(input.token);
            Account.Id accId = user.getAccountId();
            if (accId.equals(token.getAccountId())) {
                this.accountManager.link(accId, token.toAuthRequest());
                return Response.none();
            }
            throw new UnprocessableEntityException("invalid token");
        }
        catch (EmailTokenVerifier.InvalidTokenException e) {
            throw new UnprocessableEntityException("invalid token");
        }
        catch (AccountException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
    }

    public static class Input {
        @DefaultInput
        public String token;
    }
}

