/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.base.Strings;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

public class GerritServerIdProvider
implements Provider<String> {
    public static final String SECTION = "gerrit";
    public static final String KEY = "serverId";
    private final String id;

    public static String generate() {
        return UUID.randomUUID().toString();
    }

    @Inject
    GerritServerIdProvider(@GerritServerConfig Config cfg, SitePaths sitePaths) throws IOException, ConfigInvalidException {
        String origId = cfg.getString(SECTION, null, KEY);
        if (!Strings.isNullOrEmpty(origId)) {
            this.id = origId;
            return;
        }
        this.id = GerritServerIdProvider.generate();
        Config newCfg = GerritServerIdProvider.readGerritConfig(sitePaths);
        newCfg.setString(SECTION, null, KEY, this.id);
        Files.write(sitePaths.gerrit_config, newCfg.toText().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Override
    public String get() {
        return this.id;
    }

    private static Config readGerritConfig(SitePaths sitePaths) throws IOException, ConfigInvalidException {
        FileBasedConfig cfg = new FileBasedConfig(sitePaths.gerrit_config.toFile(), FS.DETECTED);
        if (!cfg.getFile().exists()) {
            return new Config();
        }
        cfg.load();
        return cfg;
    }
}

