/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.config.GcConfig;
import com.google.gerrit.server.config.ScheduleConfig;
import com.google.gerrit.server.git.GarbageCollection;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionRunner
implements Runnable {
    private static final Logger gcLog = LoggerFactory.getLogger("gc_log");
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectionRunner.class);
    private final GarbageCollection.Factory garbageCollectionFactory;
    private final ProjectCache projectCache;

    @Inject
    GarbageCollectionRunner(GarbageCollection.Factory garbageCollectionFactory, ProjectCache projectCache) {
        this.garbageCollectionFactory = garbageCollectionFactory;
        this.projectCache = projectCache;
    }

    @Override
    public void run() {
        gcLog.info("Triggering gc on all repositories");
        this.garbageCollectionFactory.create().run(Lists.newArrayList(this.projectCache.all()));
    }

    public String toString() {
        return "GC runner";
    }

    static class Lifecycle
    implements LifecycleListener {
        private final WorkQueue queue;
        private final GarbageCollectionRunner gcRunner;
        private final GcConfig gcConfig;

        @Inject
        Lifecycle(WorkQueue queue, GarbageCollectionRunner gcRunner, GcConfig config) {
            this.queue = queue;
            this.gcRunner = gcRunner;
            this.gcConfig = config;
        }

        @Override
        public void start() {
            ScheduleConfig scheduleConfig = this.gcConfig.getScheduleConfig();
            long interval = scheduleConfig.getInterval();
            long delay = scheduleConfig.getInitialDelay();
            if (delay == -1L && interval == -1L) {
                log.info("Ignoring missing gc schedule configuration");
            } else if (delay < 0L || interval <= 0L) {
                log.warn("Ignoring invalid gc schedule configuration: {}", (Object)scheduleConfig);
            } else {
                ScheduledFuture<?> scheduledFuture = this.queue.getDefaultQueue().scheduleAtFixedRate(this.gcRunner, delay, interval, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void stop() {
        }
    }
}

