/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ListSubgroups
implements RestReadView<GroupResource> {
    private static final Logger log = LoggerFactory.getLogger(ListSubgroups.class);
    private final GroupControl.Factory controlFactory;
    private final GroupIncludeCache groupIncludeCache;
    private final GroupJson json;

    @Inject
    ListSubgroups(GroupControl.Factory controlFactory, GroupIncludeCache groupIncludeCache, GroupJson json) {
        this.controlFactory = controlFactory;
        this.groupIncludeCache = groupIncludeCache;
        this.json = json;
    }

    public List<GroupInfo> apply(GroupResource rsrc) throws MethodNotAllowedException, OrmException {
        GroupDescription.Internal group = rsrc.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        boolean ownerOfParent = rsrc.getControl().isOwner();
        ArrayList<GroupInfo> included = new ArrayList<GroupInfo>();
        Collection<AccountGroup.UUID> subgroupUuids = this.groupIncludeCache.subgroupsOf(group.getGroupUUID());
        for (AccountGroup.UUID subgroupUuid : subgroupUuids) {
            try {
                GroupControl i = this.controlFactory.controlFor(subgroupUuid);
                if (!ownerOfParent && !i.isVisible()) continue;
                included.add(this.json.format(i.getGroup()));
            }
            catch (NoSuchGroupException notFound) {
                log.warn("Group {} no longer available, subgroup of {}", (Object)subgroupUuid, (Object)group.getName());
            }
        }
        Collections.sort(included, new Comparator<GroupInfo>(){

            @Override
            public int compare(GroupInfo a, GroupInfo b) {
                int cmp = Strings.nullToEmpty(a.name).compareTo(Strings.nullToEmpty(b.name));
                if (cmp != 0) {
                    return cmp;
                }
                return Strings.nullToEmpty(a.id).compareTo(Strings.nullToEmpty(b.id));
            }
        });
        return included;
    }
}

