/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.mail.EmailSettings;
import com.google.gerrit.server.mail.Encryption;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.gerrit.server.mail.receive.MailParsingException;
import com.google.gerrit.server.mail.receive.MailProcessor;
import com.google.gerrit.server.mail.receive.MailReceiver;
import com.google.gerrit.server.mail.receive.MailTransferException;
import com.google.gerrit.server.mail.receive.RawMailParser;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.commons.net.imap.IMAPSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ImapMailReceiver
extends MailReceiver {
    private static final Logger log = LoggerFactory.getLogger(ImapMailReceiver.class);
    private static final String INBOX_FOLDER = "INBOX";

    @Inject
    ImapMailReceiver(EmailSettings mailSettings, MailProcessor mailProcessor, WorkQueue workQueue) {
        super(mailSettings, mailProcessor, workQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleEmails(boolean async) throws MailTransferException, IOException {
        IMAPClient imap = this.mailSettings.encryption != Encryption.NONE ? new IMAPSClient(this.mailSettings.encryption.name(), true) : new IMAPClient();
        if (this.mailSettings.port > 0) {
            imap.setDefaultPort(this.mailSettings.port);
        }
        imap.setDefaultTimeout(30000);
        imap.connect(this.mailSettings.host);
        try {
            if (!imap.login(this.mailSettings.username, this.mailSettings.password)) {
                throw new MailTransferException("Could not login to IMAP server");
            }
            try {
                if (!imap.select(INBOX_FOLDER)) {
                    throw new MailTransferException("Could not select IMAP folder INBOX");
                }
                if (!imap.fetch("1:*", "(INTERNALDATE)")) {
                    log.info("Fetched 0 messages via IMAP");
                    return;
                }
                int numMessages = imap.getReplyStrings().length - 1;
                log.info("Fetched " + numMessages + " messages via IMAP");
                ArrayList<MailMessage> mailMessages = new ArrayList<MailMessage>(numMessages);
                for (int i = 1; i <= numMessages; ++i) {
                    if (imap.fetch(i + ":" + i, "(BODY.PEEK[])")) {
                        String[] rawMessage = imap.getReplyStrings();
                        if (rawMessage.length < 2) continue;
                        StringBuilder b = new StringBuilder(2 * (rawMessage.length - 2));
                        for (int j = 1; j < rawMessage.length - 1; ++j) {
                            if (j > 1) {
                                b.append("\n");
                            }
                            b.append(rawMessage[j]);
                        }
                        try {
                            MailMessage mailMessage = RawMailParser.parse(b.toString());
                            if (this.pendingDeletion.contains(mailMessage.id())) {
                                if (imap.store(i + ":" + i, "+FLAGS", "(\\Deleted)")) {
                                    this.pendingDeletion.remove(mailMessage.id());
                                    continue;
                                }
                                log.error("Could not mark mail message as deleted: " + mailMessage.id());
                                continue;
                            }
                            mailMessages.add(mailMessage);
                        }
                        catch (MailParsingException e) {
                            log.error("Exception while parsing email after IMAP fetch", e);
                        }
                        continue;
                    }
                    log.error("IMAP fetch failed. Will retry in next fetch cycle.");
                }
                if (!imap.expunge()) {
                    log.error("Could not expunge IMAP emails");
                }
                this.dispatchMailProcessor(mailMessages, async);
            }
            finally {
                imap.logout();
            }
        }
        finally {
            imap.disconnect();
        }
    }
}

