/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.mail.send.ChangeEmail;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.ReplyToChangeSender;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class AbandonedSender
extends ReplyToChangeSender {
    @Inject
    public AbandonedSender(EmailArguments ea, @Assisted Project.NameKey project, @Assisted Change.Id id) throws OrmException {
        super(ea, "abandon", ChangeEmail.newChangeData(ea, project, id));
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.ccAllApprovals();
        this.bccStarredBy();
        this.includeWatchers(WatchConfig.NotifyType.ABANDONED_CHANGES);
        this.removeUsersThatIgnoredTheChange();
    }

    @Override
    protected void formatChange() throws EmailException {
        this.appendText(this.textTemplate("Abandoned"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("AbandonedHtml"));
        }
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory
    extends ReplyToChangeSender.Factory<AbandonedSender> {
        @Override
        public AbandonedSender create(Project.NameKey var1, Change.Id var2);
    }
}

