/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.NotesMigrationState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.function.Function;
import org.eclipse.jgit.lib.Config;

@Singleton
public class MutableNotesMigration
extends NotesMigration {
    public static MutableNotesMigration newDisabled() {
        return new MutableNotesMigration(new Config());
    }

    public static MutableNotesMigration fromConfig(Config cfg) {
        return new MutableNotesMigration(cfg);
    }

    @Inject
    MutableNotesMigration(@GerritServerConfig Config cfg) {
        super(NotesMigration.Snapshot.create(cfg));
    }

    public MutableNotesMigration setReadChanges(boolean readChanges) {
        return this.set(b -> b.setReadChanges(readChanges));
    }

    public MutableNotesMigration setWriteChanges(boolean writeChanges) {
        return this.set(b -> b.setWriteChanges(writeChanges));
    }

    public MutableNotesMigration setReadChangeSequence(boolean readChangeSequence) {
        return this.set(b -> b.setReadChangeSequence(readChangeSequence));
    }

    public MutableNotesMigration setChangePrimaryStorage(NoteDbChangeState.PrimaryStorage changePrimaryStorage) {
        return this.set(b -> b.setChangePrimaryStorage(changePrimaryStorage));
    }

    public MutableNotesMigration setDisableChangeReviewDb(boolean disableChangeReviewDb) {
        return this.set(b -> b.setDisableChangeReviewDb(disableChangeReviewDb));
    }

    public MutableNotesMigration setFailOnLoadForTest(boolean failOnLoadForTest) {
        return this.set(b -> b.setFailOnLoadForTest(failOnLoadForTest));
    }

    public MutableNotesMigration setFrom(NotesMigrationState state) {
        this.snapshot.set(state.snapshot());
        return this;
    }

    public MutableNotesMigration setFrom(NotesMigration other) {
        this.snapshot.set(other.snapshot.get());
        return this;
    }

    private MutableNotesMigration set(Function<NotesMigration.Snapshot.Builder, NotesMigration.Snapshot.Builder> f) {
        this.snapshot.updateAndGet(s -> ((NotesMigration.Snapshot.Builder)f.apply(s.toBuilder())).build());
        return this;
    }
}

