/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.notedb.AbstractChangeUpdate;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.RevisionNoteBuilder;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.gerrit.server.notedb.RobotCommentNotes;
import com.google.gerrit.server.notedb.RobotCommentsRevisionNote;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevWalk;

public class RobotCommentUpdate
extends AbstractChangeUpdate {
    private List<RobotComment> put = new ArrayList<RobotComment>();

    @AssistedInject
    private RobotCommentUpdate(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent serverIdent, @AnonymousCowardName String anonymousCowardName, NotesMigration migration, ChangeNoteUtil noteUtil, @Assisted ChangeNotes notes, @Assisted(value="effective") Account.Id accountId, @Assisted(value="real") Account.Id realAccountId, @Assisted PersonIdent authorIdent, @Assisted Date when) {
        super(cfg, migration, noteUtil, serverIdent, anonymousCowardName, notes, null, accountId, realAccountId, authorIdent, when);
    }

    @AssistedInject
    private RobotCommentUpdate(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent serverIdent, @AnonymousCowardName String anonymousCowardName, NotesMigration migration, ChangeNoteUtil noteUtil, @Assisted Change change, @Assisted(value="effective") Account.Id accountId, @Assisted(value="real") Account.Id realAccountId, @Assisted PersonIdent authorIdent, @Assisted Date when) {
        super(cfg, migration, noteUtil, serverIdent, anonymousCowardName, null, change, accountId, realAccountId, authorIdent, when);
    }

    public void putComment(RobotComment c) {
        this.verifyComment(c);
        this.put.add(c);
    }

    private CommitBuilder storeCommentsInNotes(RevWalk rw, ObjectInserter ins, ObjectId curr, CommitBuilder cb) throws ConfigInvalidException, OrmException, IOException {
        RevisionNoteMap<RobotCommentsRevisionNote> rnm = this.getRevisionNoteMap(rw, curr);
        HashSet<RevId> updatedRevs = Sets.newHashSetWithExpectedSize(rnm.revisionNotes.size());
        RevisionNoteBuilder.Cache cache = new RevisionNoteBuilder.Cache(rnm);
        for (RobotComment c : this.put) {
            cache.get(new RevId(c.revId)).putComment(c);
        }
        Map<RevId, RevisionNoteBuilder> builders = cache.getBuilders();
        boolean touchedAnyRevs = false;
        boolean hasComments = false;
        for (Map.Entry<RevId, RevisionNoteBuilder> e : builders.entrySet()) {
            updatedRevs.add(e.getKey());
            ObjectId id = ObjectId.fromString(e.getKey().get());
            byte[] data = e.getValue().build(this.noteUtil, true);
            if (!Arrays.equals(data, e.getValue().baseRaw)) {
                touchedAnyRevs = true;
            }
            if (data.length == 0) {
                rnm.noteMap.remove(id);
                continue;
            }
            hasComments = true;
            ObjectId dataBlob = ins.insert(3, data);
            rnm.noteMap.set(id, dataBlob);
        }
        if (!touchedAnyRevs) {
            return NO_OP_UPDATE;
        }
        boolean touchedAllRevs = updatedRevs.equals(rnm.revisionNotes.keySet());
        if (touchedAllRevs && !hasComments) {
            return null;
        }
        cb.setTreeId(rnm.noteMap.writeTree(ins));
        return cb;
    }

    private RevisionNoteMap<RobotCommentsRevisionNote> getRevisionNoteMap(RevWalk rw, ObjectId curr) throws ConfigInvalidException, OrmException, IOException {
        RobotCommentNotes robotCommentNotes;
        ChangeNotes changeNotes;
        if (curr.equals(ObjectId.zeroId())) {
            return RevisionNoteMap.emptyMap();
        }
        if (this.migration.readChanges() && (changeNotes = this.getNotes()) != null && (robotCommentNotes = ((ChangeNotes)changeNotes.load()).getRobotCommentNotes()) != null) {
            ObjectId idFromNotes = MoreObjects.firstNonNull(robotCommentNotes.getRevision(), ObjectId.zeroId());
            RevisionNoteMap<RobotCommentsRevisionNote> rnm = robotCommentNotes.getRevisionNoteMap();
            if (idFromNotes.equals(curr) && rnm != null) {
                return rnm;
            }
        }
        NoteMap noteMap = !curr.equals(ObjectId.zeroId()) ? NoteMap.read(rw.getObjectReader(), rw.parseCommit(curr)) : NoteMap.newEmptyMap();
        return RevisionNoteMap.parseRobotComments(this.noteUtil, rw.getObjectReader(), noteMap);
    }

    @Override
    protected CommitBuilder applyImpl(RevWalk rw, ObjectInserter ins, ObjectId curr) throws OrmException, IOException {
        CommitBuilder cb = new CommitBuilder();
        cb.setMessage("Update robot comments");
        try {
            return this.storeCommentsInNotes(rw, ins, curr, cb);
        }
        catch (ConfigInvalidException e) {
            throw new OrmException(e);
        }
    }

    @Override
    protected Project.NameKey getProjectName() {
        return this.getNotes().getProjectName();
    }

    @Override
    protected String getRefName() {
        return RefNames.robotCommentsRef(this.getId());
    }

    @Override
    public boolean isEmpty() {
        return this.put.isEmpty();
    }

    public static interface Factory {
        public RobotCommentUpdate create(ChangeNotes var1, @Assisted(value="effective") Account.Id var2, @Assisted(value="real") Account.Id var3, PersonIdent var4, Date var5);

        public RobotCommentUpdate create(Change var1, @Assisted(value="effective") Account.Id var2, @Assisted(value="real") Account.Id var3, PersonIdent var4, Date var5);
    }
}

