/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.common.MergeableInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.InMemoryInserter;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.project.BranchResource;
import com.google.gerrit.server.project.CommitsCollection;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

public class CheckMergeability
implements RestReadView<BranchResource> {
    private String source;
    private String strategy;
    private SubmitType submitType;
    private final GitRepositoryManager gitManager;
    private final CommitsCollection commits;

    @Option(name="--source", metaVar="COMMIT", usage="the source reference to merge, which could be any git object references expression, refer to org.eclipse.jgit.lib.Repository#resolve(String)", required=true)
    public void setSource(String source) {
        this.source = source;
    }

    @Option(name="--strategy", metaVar="STRATEGY", usage="name of the merge strategy, refer to org.eclipse.jgit.merge.MergeStrategy")
    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    @Inject
    CheckMergeability(GitRepositoryManager gitManager, CommitsCollection commits, @GerritServerConfig Config cfg) {
        this.gitManager = gitManager;
        this.commits = commits;
        this.strategy = MergeUtil.getMergeStrategy(cfg).getName();
        this.submitType = cfg.getEnum("project", null, "submitType", SubmitType.MERGE_IF_NECESSARY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MergeableInfo apply(BranchResource resource) throws IOException, BadRequestException, ResourceNotFoundException {
        if (!this.submitType.equals((Object)SubmitType.MERGE_ALWAYS) && !this.submitType.equals((Object)SubmitType.MERGE_IF_NECESSARY)) {
            throw new BadRequestException("Submit type: " + (Object)((Object)this.submitType) + " is not supported");
        }
        MergeableInfo result = new MergeableInfo();
        result.submitType = this.submitType;
        result.strategy = this.strategy;
        try (Repository git = this.gitManager.openRepository(resource.getNameKey());
             RevWalk rw = new RevWalk(git);
             InMemoryInserter inserter = new InMemoryInserter(git);){
            Merger m = MergeUtil.newMerger(inserter, git.getConfig(), this.strategy);
            Ref destRef = git.getRefDatabase().exactRef(resource.getRef());
            if (destRef == null) {
                throw new ResourceNotFoundException(resource.getRef());
            }
            RevCommit targetCommit = rw.parseCommit(destRef.getObjectId());
            RevCommit sourceCommit = MergeUtil.resolveCommit(git, rw, this.source);
            if (!this.commits.canRead(resource.getProjectState(), git, sourceCommit)) {
                throw new BadRequestException("do not have read permission for: " + this.source);
            }
            if (rw.isMergedInto(sourceCommit, targetCommit)) {
                result.mergeable = true;
                result.commitMerged = true;
                result.contentMerged = true;
                MergeableInfo mergeableInfo = result;
                return mergeableInfo;
            }
            if (m.merge(false, targetCommit, sourceCommit)) {
                result.mergeable = true;
                result.commitMerged = false;
                result.contentMerged = m.getResultTreeId().equals(targetCommit.getTree());
                return result;
            }
            result.mergeable = false;
            if (!(m instanceof ResolveMerger)) return result;
            result.conflicts = ((ResolveMerger)m).getUnmergedPaths();
            return result;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }
}

