/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.common.data.GarbageCollectionResult;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.git.GarbageCollection;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LocalDiskRepositoryManager;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.util.IdGenerator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

@RequiresCapability(value="runGC")
@Singleton
public class GarbageCollect
implements RestModifyView<ProjectResource, Input>,
UiAction<ProjectResource> {
    private final boolean canGC;
    private final GarbageCollection.Factory garbageCollectionFactory;
    private final WorkQueue workQueue;
    private final Provider<String> canonicalUrl;

    @Inject
    GarbageCollect(GitRepositoryManager repoManager, GarbageCollection.Factory garbageCollectionFactory, WorkQueue workQueue, @CanonicalWebUrl Provider<String> canonicalUrl) {
        this.workQueue = workQueue;
        this.canonicalUrl = canonicalUrl;
        this.canGC = repoManager instanceof LocalDiskRepositoryManager;
        this.garbageCollectionFactory = garbageCollectionFactory;
    }

    @Override
    public Object apply(ProjectResource rsrc, Input input) {
        Project.NameKey project = rsrc.getNameKey();
        if (input.async) {
            return this.applyAsync(project, input);
        }
        return this.applySync(project, input);
    }

    private Response.Accepted applyAsync(final Project.NameKey project, final Input input) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                GarbageCollect.this.runGC(project, input, null);
            }

            public String toString() {
                return "Run " + (input.aggressive ? "aggressive " : "") + "garbage collection on project " + project.get();
            }
        };
        WorkQueue.Task task = (WorkQueue.Task)this.workQueue.getDefaultQueue().submit(job);
        String location = this.canonicalUrl.get() + "a/config/server/tasks/" + IdGenerator.format(task.getTaskId());
        return Response.accepted(location);
    }

    private BinaryResult applySync(final Project.NameKey project, final Input input) {
        return new BinaryResult(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeTo(OutputStream out) throws IOException {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)){

                    @Override
                    public void println() {
                        this.write(10);
                    }
                };
                try {
                    PrintWriter progressWriter = input.showProgress ? writer : null;
                    GarbageCollectionResult result = GarbageCollect.this.runGC(project, input, progressWriter);
                    String msg = "Garbage collection completed successfully.";
                    if (result.hasErrors()) {
                        block8: for (GarbageCollectionResult.Error e : result.getErrors()) {
                            switch (e.getType()) {
                                case REPOSITORY_NOT_FOUND: {
                                    msg = "Error: project \"" + e.getProjectName() + "\" not found.";
                                    continue block8;
                                }
                                case GC_ALREADY_SCHEDULED: {
                                    msg = "Error: garbage collection for project \"" + e.getProjectName() + "\" was already scheduled.";
                                    continue block8;
                                }
                                case GC_FAILED: {
                                    msg = "Error: garbage collection for project \"" + e.getProjectName() + "\" failed.";
                                    continue block8;
                                }
                            }
                            msg = "Error: garbage collection for project \"" + e.getProjectName() + "\" failed: " + (Object)((Object)e.getType()) + ".";
                        }
                    }
                    writer.println(msg);
                }
                finally {
                    writer.flush();
                }
            }
        }.setContentType("text/plain").setCharacterEncoding(StandardCharsets.UTF_8).disableGzip();
    }

    GarbageCollectionResult runGC(Project.NameKey project, Input input, PrintWriter progressWriter) {
        return this.garbageCollectionFactory.create().run(Collections.singletonList(project), input.aggressive, progressWriter);
    }

    @Override
    public UiAction.Description getDescription(ProjectResource rsrc) {
        return new UiAction.Description().setLabel("Run GC").setTitle("Triggers the Git Garbage Collection for this project.").setVisible(this.canGC);
    }

    public static class Input {
        public boolean showProgress;
        public boolean aggressive;
        public boolean async;
    }
}

