/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.api.access.AccessSectionInfo;
import com.google.gerrit.extensions.api.access.PermissionInfo;
import com.google.gerrit.extensions.api.access.PermissionRuleInfo;
import com.google.gerrit.extensions.api.access.ProjectAccessInfo;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GetAccess
implements RestReadView<ProjectResource> {
    private static final Logger LOG = LoggerFactory.getLogger(GetAccess.class);
    private static final GroupInfo INVISIBLE_SENTINEL = new GroupInfo();
    public static final ImmutableBiMap<PermissionRule.Action, PermissionRuleInfo.Action> ACTION_TYPE = ImmutableBiMap.of(PermissionRule.Action.ALLOW, PermissionRuleInfo.Action.ALLOW, PermissionRule.Action.BATCH, PermissionRuleInfo.Action.BATCH, PermissionRule.Action.BLOCK, PermissionRuleInfo.Action.BLOCK, PermissionRule.Action.DENY, PermissionRuleInfo.Action.DENY, PermissionRule.Action.INTERACTIVE, PermissionRuleInfo.Action.INTERACTIVE);
    private final Provider<CurrentUser> user;
    private final PermissionBackend permissionBackend;
    private final GroupControl.Factory groupControlFactory;
    private final AllProjectsName allProjectsName;
    private final ProjectJson projectJson;
    private final ProjectCache projectCache;
    private final Provider<MetaDataUpdate.Server> metaDataUpdateFactory;
    private final ProjectControl.GenericFactory projectControlFactory;
    private final GroupBackend groupBackend;
    private final GroupJson groupJson;

    @Inject
    public GetAccess(Provider<CurrentUser> self, PermissionBackend permissionBackend, GroupControl.Factory groupControlFactory, AllProjectsName allProjectsName, ProjectCache projectCache, Provider<MetaDataUpdate.Server> metaDataUpdateFactory, ProjectJson projectJson, ProjectControl.GenericFactory projectControlFactory, GroupBackend groupBackend, GroupJson groupJson) {
        this.user = self;
        this.permissionBackend = permissionBackend;
        this.groupControlFactory = groupControlFactory;
        this.allProjectsName = allProjectsName;
        this.projectJson = projectJson;
        this.projectCache = projectCache;
        this.projectControlFactory = projectControlFactory;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.groupBackend = groupBackend;
        this.groupJson = groupJson;
    }

    public ProjectAccessInfo apply(Project.NameKey nameKey) throws ResourceNotFoundException, ResourceConflictException, IOException, PermissionBackendException, OrmException {
        try {
            return this.apply(new ProjectResource(this.projectControlFactory.controlFor(nameKey, this.user.get())));
        }
        catch (NoSuchProjectException e) {
            throw new ResourceNotFoundException(nameKey.get());
        }
    }

    public ProjectAccessInfo apply(ProjectResource rsrc) throws ResourceNotFoundException, ResourceConflictException, IOException, PermissionBackendException, OrmException {
        ProjectState parent;
        ProjectConfig config;
        Project.NameKey projectName = rsrc.getNameKey();
        ProjectAccessInfo info = new ProjectAccessInfo();
        ProjectControl pc = this.createProjectControl(projectName);
        PermissionBackend.ForProject perm = this.permissionBackend.user(this.user).project(projectName);
        try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(projectName);){
            config = ProjectConfig.read(md);
            if (config.updateGroupNames(this.groupBackend)) {
                md.setMessage("Update group names\n");
                config.commit(md);
                this.projectCache.evict(config.getProject());
                pc = this.createProjectControl(projectName);
                perm = this.permissionBackend.user(this.user).project(projectName);
            } else if (config.getRevision() != null && !config.getRevision().equals(pc.getProjectState().getConfig().getRevision())) {
                this.projectCache.evict(config.getProject());
                pc = this.createProjectControl(projectName);
                perm = this.permissionBackend.user(this.user).project(projectName);
            }
        }
        catch (ConfigInvalidException e2) {
            throw new ResourceConflictException(e2.getMessage());
        }
        catch (RepositoryNotFoundException e3) {
            throw new ResourceNotFoundException(rsrc.getName());
        }
        info.local = new HashMap<String, AccessSectionInfo>();
        info.ownerOf = new HashSet<String>();
        HashMap<AccountGroup.UUID, GroupInfo> visibleGroups = new HashMap<AccountGroup.UUID, GroupInfo>();
        boolean checkReadConfig = GetAccess.check(perm, "refs/meta/config", RefPermission.READ);
        for (AccessSection section : config.getAccessSections()) {
            String name = section.getName();
            if ("GLOBAL_CAPABILITIES".equals(name)) {
                if (pc.isOwner()) {
                    info.local.put(name, this.createAccessSection(visibleGroups, section));
                    info.ownerOf.add(name);
                    continue;
                }
                if (!checkReadConfig) continue;
                info.local.put(section.getName(), this.createAccessSection(visibleGroups, section));
                continue;
            }
            if (!RefConfigSection.isValid(name)) continue;
            if (pc.controlForRef(name).isOwner()) {
                info.local.put(name, this.createAccessSection(visibleGroups, section));
                info.ownerOf.add(name);
                continue;
            }
            if (checkReadConfig) {
                info.local.put(name, this.createAccessSection(visibleGroups, section));
                continue;
            }
            if (!GetAccess.check(perm, name, RefPermission.READ)) continue;
            AccessSection dst = null;
            for (Permission srcPerm : section.getPermissions()) {
                Permission dstPerm = null;
                for (PermissionRule srcRule : srcPerm.getRules()) {
                    GroupInfo group;
                    AccountGroup.UUID groupId = srcRule.getGroup().getUUID();
                    if (groupId == null || (group = this.loadGroup(visibleGroups, groupId)) == INVISIBLE_SENTINEL) continue;
                    if (dstPerm == null) {
                        if (dst == null) {
                            dst = new AccessSection(name);
                            info.local.put(name, this.createAccessSection(visibleGroups, dst));
                        }
                        dstPerm = dst.getPermission(srcPerm.getName(), true);
                    }
                    dstPerm.add(srcRule);
                }
            }
        }
        if (info.ownerOf.isEmpty() && this.permissionBackend.user(this.user).test(GlobalPermission.ADMINISTRATE_SERVER)) {
            info.ownerOf.add("refs/*");
        }
        if (config.getRevision() != null) {
            info.revision = config.getRevision().name();
        }
        if ((parent = (ProjectState)Iterables.getFirst(pc.getProjectState().parents(), null)) != null) {
            info.inheritsFrom = this.projectJson.format(parent.getProject());
        }
        if (projectName.equals(this.allProjectsName) && this.permissionBackend.user(this.user).testOrFalse(GlobalPermission.ADMINISTRATE_SERVER)) {
            info.ownerOf.add("GLOBAL_CAPABILITIES");
        }
        info.isOwner = GetAccess.toBoolean(pc.isOwner());
        info.canUpload = GetAccess.toBoolean(pc.isOwner() || checkReadConfig && perm.ref("refs/meta/config").testOrFalse(RefPermission.CREATE_CHANGE));
        info.canAdd = GetAccess.toBoolean(perm.testOrFalse(ProjectPermission.CREATE_REF));
        info.canAddTags = GetAccess.toBoolean(perm.testOrFalse(ProjectPermission.CREATE_TAG_REF));
        info.configVisible = checkReadConfig || pc.isOwner();
        info.groups = visibleGroups.entrySet().stream().filter(e -> e.getValue() != INVISIBLE_SENTINEL).collect(Collectors.toMap(e -> ((AccountGroup.UUID)e.getKey()).get(), e -> (GroupInfo)e.getValue()));
        return info;
    }

    private GroupInfo loadGroup(Map<AccountGroup.UUID, GroupInfo> visibleGroups, AccountGroup.UUID id) throws OrmException {
        GroupInfo group = visibleGroups.get(id);
        if (group == null) {
            try {
                GroupControl control = this.groupControlFactory.controlFor(id);
                group = INVISIBLE_SENTINEL;
                if (control.isVisible()) {
                    group = this.groupJson.format(control.getGroup());
                    group.id = null;
                }
            }
            catch (NoSuchGroupException e) {
                LOG.warn("NoSuchGroupException; ignoring group " + id, e);
                group = INVISIBLE_SENTINEL;
            }
            visibleGroups.put(id, group);
        }
        return group;
    }

    private static boolean check(PermissionBackend.ForProject ctx, String ref, RefPermission perm) throws PermissionBackendException {
        try {
            ctx.ref(ref).check(perm);
            return true;
        }
        catch (AuthException denied) {
            return false;
        }
    }

    private AccessSectionInfo createAccessSection(Map<AccountGroup.UUID, GroupInfo> groups, AccessSection section) throws OrmException {
        AccessSectionInfo accessSectionInfo = new AccessSectionInfo();
        accessSectionInfo.permissions = new HashMap<String, PermissionInfo>();
        for (Permission p : section.getPermissions()) {
            PermissionInfo pInfo = new PermissionInfo(p.getLabel(), p.getExclusiveGroup() != false ? Boolean.valueOf(true) : null);
            pInfo.rules = new HashMap<String, PermissionRuleInfo>();
            for (PermissionRule r : p.getRules()) {
                AccountGroup.UUID group;
                PermissionRuleInfo info = new PermissionRuleInfo((PermissionRuleInfo.Action)((Object)ACTION_TYPE.get((Object)r.getAction())), r.getForce());
                if (r.hasRange()) {
                    info.max = r.getMax();
                    info.min = r.getMin();
                }
                if ((group = r.getGroup().getUUID()) == null) continue;
                pInfo.rules.put(group.get(), info);
                this.loadGroup(groups, group);
            }
            accessSectionInfo.permissions.put(p.getName(), pInfo);
        }
        return accessSectionInfo;
    }

    private ProjectControl createProjectControl(Project.NameKey projectName) throws IOException, ResourceNotFoundException {
        try {
            return this.projectControlFactory.controlFor(projectName, this.user.get());
        }
        catch (NoSuchProjectException e) {
            throw new ResourceNotFoundException(projectName.get());
        }
    }

    private static Boolean toBoolean(boolean value) {
        return value ? Boolean.valueOf(true) : null;
    }
}

