/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.RepositoryStatistics;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;

@RequiresCapability(value="runGC")
@Singleton
public class GetStatistics
implements RestReadView<ProjectResource> {
    private final GitRepositoryManager repoManager;

    @Inject
    GetStatistics(GitRepositoryManager repoManager) {
        this.repoManager = repoManager;
    }

    public RepositoryStatistics apply(ProjectResource rsrc) throws ResourceNotFoundException, ResourceConflictException {
        Repository repo = this.repoManager.openRepository(rsrc.getNameKey());
        try {
            GarbageCollectCommand gc = Git.wrap(repo).gc();
            RepositoryStatistics repositoryStatistics = new RepositoryStatistics(gc.getStatistics());
            if (repo != null) {
                repo.close();
            }
            return repositoryStatistics;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        repo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (GitAPIException | JGitInternalException e) {
                throw new ResourceConflictException(e.getMessage());
            }
            catch (IOException e) {
                throw new ResourceNotFoundException(rsrc.getName());
            }
        }
    }
}

