/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.config.ThreadSettingsConfig;
import com.google.gerrit.server.schema.JdbcAccountPatchReviewStore;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.jgit.lib.Config;

@Singleton
public class MysqlAccountPatchReviewStore
extends JdbcAccountPatchReviewStore {
    @Inject
    MysqlAccountPatchReviewStore(@GerritServerConfig Config cfg, SitePaths sitePaths, ThreadSettingsConfig threadSettingsConfig) {
        super(cfg, sitePaths, threadSettingsConfig);
    }

    @Override
    public OrmException convertError(String op, SQLException err) {
        switch (err.getErrorCode()) {
            case 1022: 
            case 1062: 
            case 1169: {
                return new OrmDuplicateKeyException("ACCOUNT_PATCH_REVIEWS", err);
            }
        }
        if (err.getCause() == null && err.getNextException() != null) {
            err.initCause(err.getNextException());
        }
        return new OrmException(op + " failure on ACCOUNT_PATCH_REVIEWS", err);
    }

    @Override
    protected void doCreateTable(Statement stmt) throws SQLException {
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS account_patch_reviews (account_id INTEGER DEFAULT 0 NOT NULL, change_id INTEGER DEFAULT 0 NOT NULL, patch_set_id INTEGER DEFAULT 0 NOT NULL, file_name VARCHAR(255) DEFAULT '' NOT NULL, CONSTRAINT primary_key_account_patch_reviews PRIMARY KEY (change_id, patch_set_id, account_id, file_name))");
    }
}

